/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GDocumentEnvelope;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GXmlEntity;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.model.answer.GConditionAnswer;
import net.geocentral.geometria.model.answer.GFixedPlaneAnswer;
import net.geocentral.geometria.model.answer.GNumberAnswer;
import net.geocentral.geometria.model.answer.GPointSetAnswer;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GVersionManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GProblem
extends GDocument {
    private GDocumentEnvelope envelope = new GDocumentEnvelope();
    private Document text = new PlainDocument();
    private GAnswer answer = new GNumberAnswer();
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public void make(Element node, GXmlEntity parent) throws Exception {
        logger.info((Object)"");
        this.makeVersion(node, parent);
        this.envelope.make((Element)node.getElementsByTagName("envelope").item(0));
        String s = node.getElementsByTagName("text").item(0).getTextContent();
        s = GStringUtils.fromXml(s);
        this.text.insertString(0, s, null);
        this.makeFigures(node);
        this.notepad.make((Element)node.getElementsByTagName("notepad").item(0));
        this.makeAnswer((Element)node.getElementsByTagName("answer").item(0));
    }

    private void makeAnswer(Element node) throws Exception {
        logger.info((Object)"");
        String type = node.getElementsByTagName("type").item(0).getTextContent();
        if (type.equals("number")) {
            this.answer = new GNumberAnswer();
        } else if (type.equals("pointSet")) {
            this.answer = new GPointSetAnswer();
        } else if (type.equals("fixedPlane")) {
            this.answer = new GFixedPlaneAnswer();
        } else if (type.equals("conditionPlane")) {
            this.answer = new GConditionAnswer();
        } else {
            logger.error((Object)type);
            throw new Exception();
        }
        this.answer.make(node, this);
    }

    private void makeFigures(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = ((Element)node.getElementsByTagName("figures").item(0)).getElementsByTagName("figure");
        for (int i = 0; i < ns.getLength(); ++i) {
            Element n = (Element)ns.item(i);
            GFigure figure = new GFigure();
            figure.make(n, this);
            if (this.figures.containsKey(figure.getName())) {
                logger.error((Object)("Duplicate figure name: " + figure.getName()));
                throw new Exception();
            }
            this.addFigure(figure);
        }
        this.setSelectedFigure(0);
    }

    public void serialize(StringBuffer buf, boolean preamble) {
        String s;
        logger.info((Object)"");
        if (preamble) {
            buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n<problem xmlns=\"").append("http://geocentral.net").append("\">").append("\n<version>").append(GVersionManager.getInstance().getApplicationVersion()).append("</version>");
        } else {
            buf.append("\n<problem>");
        }
        this.envelope.serialize(buf);
        buf.append("\n<text>");
        try {
            s = this.text.getText(0, this.text.getLength()).trim();
        }
        catch (Exception exception) {
            logger.error((Object)this.text);
            s = "";
        }
        s = GStringUtils.toXml(s);
        buf.append(s);
        buf.append("</text>");
        this.notepad.serialize(buf);
        buf.append("\n<figures>");
        for (GFigure figure : this.figures.values()) {
            figure.serialize(buf);
        }
        buf.append("\n</figures>");
        this.answer.serialize(buf);
        buf.append("\n</problem>");
    }

    public void clearNotepad() {
        logger.info((Object)"");
        this.notepad.clear();
    }

    public String getSchemaFile(String version) {
        return GVersionManager.getInstance().getProblemSchema(version);
    }

    public GDocumentEnvelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(GDocumentEnvelope envelope) {
        logger.info((Object)envelope);
        this.envelope = envelope;
    }

    public Document getText() {
        return this.text;
    }

    public GAnswer getAnswer() {
        return this.answer;
    }

    public void setAnswer(GAnswer answer) {
        this.answer = answer;
    }
}

