/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.Map;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GEraseLineAction;
import net.geocentral.geometria.action.GEraseSelectionAction;
import net.geocentral.geometria.action.GRemoveFigureAction;
import net.geocentral.geometria.action.GRenameFigureAction;
import net.geocentral.geometria.action.GRenamePointAction;
import net.geocentral.geometria.action.GRenameVariableAction;
import net.geocentral.geometria.model.GCalculation;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GMeasurement;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GRecordable;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GNotepadRecord {
    private GNotepadVariable variable;
    private GRecordable recordable;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GNotepadRecord() {
    }

    public GNotepadRecord(GNotepadVariable variable, GCalculation calculation) {
        this.variable = variable;
        this.recordable = calculation;
        logger.info((Object)this);
    }

    public GNotepadRecord(GNotepadVariable variable, GMeasurement measurement) {
        this.variable = variable;
        this.recordable = measurement;
        logger.info((Object)this);
    }

    public void make(Element node) throws Exception {
        NodeList nns;
        logger.info((Object)"");
        String variableName = node.getElementsByTagName("variable").item(0).getTextContent();
        NodeList ns = node.getElementsByTagName("measurement");
        if (ns.getLength() > 0) {
            Element n = (Element)ns.item(0);
            this.recordable = new GMeasurement();
            this.recordable.make(n);
            this.variable = new GNotepadVariable(variableName, null);
        }
        if ((nns = node.getElementsByTagName("calculation")).getLength() > 0) {
            Element n = (Element)nns.item(0);
            this.recordable = new GCalculation();
            this.recordable.make(n);
            this.variable = new GNotepadVariable(variableName, null);
        }
    }

    public void validate(GDocument document, Map<String, GNotepadVariable> variables) throws Exception {
        logger.info((Object)this);
        if (variables.containsKey(this.variable.getName())) {
            logger.error((Object)this.variable);
            throw new Exception();
        }
        if (this.recordable instanceof GMeasurement) {
            if (!((GMeasurement)this.recordable).isDeprecated()) {
                double value = ((GMeasurement)this.recordable).getValue(document);
                this.variable.setValue(value);
            }
        } else {
            double value = ((GCalculation)this.recordable).getValue(variables);
            this.variable.setValue(value);
        }
        logger.info((Object)this);
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<record>");
        buf.append("\n<variable>");
        buf.append(this.variable.getName());
        buf.append("</variable>");
        if (this.recordable instanceof GCalculation) {
            this.recordable.serialize(buf);
        } else if (!((GMeasurement)this.recordable).isDeprecated()) {
            this.recordable.serialize(buf);
        } else {
            GCalculation calculation = new GCalculation(String.valueOf(this.variable.getValue()));
            calculation.serialize(buf);
        }
        buf.append("\n</record>");
    }

    public void figureRenamed(GRenameFigureAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).figureRenamed(action);
        }
    }

    public void renameFigureUndone(GRenameFigureAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).renameFigureUndone(action);
        }
    }

    public void pointRenamed(GRenamePointAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).pointRenamed(action);
        }
    }

    public void renamePointUndone(GRenamePointAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).renamePointUndone(action);
        }
    }

    public void variableRenamed(GRenameVariableAction action) {
        String oldName = action.getOldName();
        String newName = action.getNewName();
        if (this.variable.getName().equals(oldName)) {
            this.variable.setName(newName);
        } else if (this.recordable instanceof GCalculation) {
            ((GCalculation)this.recordable).variableRenamed(action);
        }
    }

    public void renameVariableUndone(GRenameVariableAction action) {
        String oldName = action.getOldName();
        String newName = action.getNewName();
        if (this.variable.getName().equals(newName)) {
            this.variable.setName(oldName);
        } else if (this.recordable instanceof GCalculation) {
            ((GCalculation)this.recordable).renameVariableUndone(action);
        }
    }

    public void figureRemoved(GRemoveFigureAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).figureRemoved(action);
        }
    }

    public void removeFigureUndone(GRemoveFigureAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).removeFigureUndone(action);
        }
    }

    public void lineErased(GEraseLineAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).lineErased(action);
        }
    }

    public void eraseLineUndone(GEraseLineAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).eraseLineUndone(action);
        }
    }

    public void selectionErased(GEraseSelectionAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).selectionErased(action);
        }
    }

    public void eraseSelectionUndone(GEraseSelectionAction action) {
        if (this.recordable instanceof GMeasurement) {
            ((GMeasurement)this.recordable).eraseSelectionUndone(action);
        }
    }

    public GNotepadVariable getVariable() {
        return this.variable;
    }

    public String getExpression() {
        return this.recordable.getExpression();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.variable.getName());
        if (this.recordable instanceof GCalculation) {
            buf.append("=").append(this.recordable.getExpression());
        } else if (!((GMeasurement)this.recordable).isDeprecated()) {
            buf.append("=").append(((GMeasurement)this.recordable).getExpressionString());
            GDocument document = GDocumentHandler.getInstance().getActiveDocument();
            if (document != null && document.getFigureCount() > 1) {
                buf.append(" : ").append(((GMeasurement)this.recordable).getFigureName());
            }
        }
        return String.valueOf(buf);
    }
}

