/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataListener;
import net.geocentral.geometria.action.GEraseLineAction;
import net.geocentral.geometria.action.GEraseSelectionAction;
import net.geocentral.geometria.action.GRemoveFigureAction;
import net.geocentral.geometria.action.GRenameFigureAction;
import net.geocentral.geometria.action.GRenamePointAction;
import net.geocentral.geometria.action.GRenameVariableAction;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GNotepad {
    private GDocument document;
    private DefaultListModel model;
    private ListSelectionModel selectionModel;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GNotepad(GDocument document) {
        this.document = document;
        this.model = new DefaultListModel();
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void add(GNotepadRecord record) {
        logger.info((Object)record);
        this.model.addElement(record);
    }

    public void removeLastRecord() {
        GNotepadRecord record = (GNotepadRecord)this.model.remove(this.model.getSize() - 1);
        logger.info((Object)record);
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<notepad>");
        for (int i = 0; i < this.model.size(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.serialize(buf);
        }
        buf.append("\n</notepad>");
    }

    public void make(Element node) throws Exception {
        ListDataListener[] listeners;
        logger.info((Object)"");
        for (ListDataListener listener : listeners = (ListDataListener[])this.model.getListeners(ListDataListener.class)) {
            this.model.removeListDataListener(listener);
        }
        NodeList ns = node.getElementsByTagName("record");
        for (int i = 0; i < ns.getLength(); ++i) {
            Element n = (Element)ns.item(i);
            GNotepadRecord record = new GNotepadRecord();
            record.make(n);
            this.add(record);
        }
        for (ListDataListener listener : listeners) {
            this.model.addListDataListener(listener);
        }
    }

    public void validate() throws Exception {
        logger.info((Object)"");
        LinkedHashMap<String, GNotepadVariable> variables = new LinkedHashMap<String, GNotepadVariable>();
        for (int i = 0; i < this.model.size(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.validate(this.document, variables);
            GNotepadVariable variable = record.getVariable();
            variables.put(variable.getName(), variable);
        }
    }

    public void update() {
        logger.info((Object)"");
        try {
            this.validate();
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
        }
    }

    public ListModel getModel() {
        return this.model;
    }

    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    public int size() {
        return this.model.size();
    }

    public GNotepadRecord getRecord(String variableName) {
        for (int i = 0; i < this.model.size(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            GNotepadVariable variable = record.getVariable();
            if (!variable.getName().equals(variableName)) continue;
            return record;
        }
        return null;
    }

    public List<GNotepadRecord> getRecords() {
        ArrayList<GNotepadRecord> records = new ArrayList<GNotepadRecord>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            records.add(record);
        }
        return records;
    }

    public void figureRenamed(GRenameFigureAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.figureRenamed(action);
        }
    }

    public void renameFigureUndone(GRenameFigureAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.renameFigureUndone(action);
        }
    }

    public void pointRenamed(GRenamePointAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.pointRenamed(action);
        }
    }

    public void renamePointUndone(GRenamePointAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.renamePointUndone(action);
        }
    }

    public void renameVariable(GRenameVariableAction action) {
        logger.info((Object)"");
        String oldName = action.getOldName();
        GNotepadRecord definitionRecord = this.getRecord(oldName);
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            if (record == definitionRecord) continue;
            record.variableRenamed(action);
        }
        definitionRecord.variableRenamed(action);
    }

    public void undoRenameVariable(GRenameVariableAction action) {
        logger.info((Object)"");
        String newName = action.getNewName();
        GNotepadRecord definitionRecord = this.getRecord(newName);
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            if (record == definitionRecord) continue;
            record.renameVariableUndone(action);
        }
        definitionRecord.renameVariableUndone(action);
    }

    public void clear() {
        logger.info((Object)"");
        this.model.clear();
    }

    public List<GNotepadVariable> getVariables() {
        ArrayList<GNotepadVariable> variables = new ArrayList<GNotepadVariable>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            GNotepadVariable variable = record.getVariable();
            variables.add(variable);
        }
        return variables;
    }

    public void figureRemoved(GRemoveFigureAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.figureRemoved(action);
        }
    }

    public void removeFigureUndone(GRemoveFigureAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.removeFigureUndone(action);
        }
    }

    public void lineErased(GEraseLineAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.lineErased(action);
        }
    }

    public void eraseLineUndone(GEraseLineAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.eraseLineUndone(action);
        }
    }

    public void selectionErased(GEraseSelectionAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.selectionErased(action);
        }
    }

    public void eraseSelectionUndone(GEraseSelectionAction action) {
        logger.info((Object)"");
        for (int i = 0; i < this.model.getSize(); ++i) {
            GNotepadRecord record = (GNotepadRecord)this.model.get(i);
            record.eraseSelectionUndone(action);
        }
    }

    public GNotepadRecord getSelectedRecord() {
        int index = this.selectionModel.getMaxSelectionIndex();
        if (index < 0) {
            return null;
        }
        return (GNotepadRecord)this.model.getElementAt(index);
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }
}

