/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GEraseLineAction;
import net.geocentral.geometria.action.GEraseSelectionAction;
import net.geocentral.geometria.action.GRemoveFigureAction;
import net.geocentral.geometria.action.GRenameFigureAction;
import net.geocentral.geometria.action.GRenamePointAction;
import net.geocentral.geometria.action.GUndoable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GRecordable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMeasurement
implements GRecordable {
    public static final Pattern DISTANCE_PATTERN = Pattern.compile("\\s*\\|\\s*([A-Z][0-9]*)\\s*([A-Z][0-9]*)\\s*\\|\\s*");
    public static final Pattern ANGLE_PATTERN = Pattern.compile("\\s*<\\s*([A-Z][0-9]*)\\s*([A-Z][0-9]*)\\s*([A-Z][0-9]*)\\s*");
    public static final Pattern AREA_PATTERN = Pattern.compile("\\s*area\\s*\\[([A-Z][0-9]*)\\s*([A-Z][0-9]*)\\s*([A-Z][0-9]*)\\s*\\]\\s*");
    public static final Pattern VOLUME_PATTERN = Pattern.compile("\\s*volume\\s*");
    private String expression;
    private String figureName;
    private boolean deprecated;
    private GUndoable deprecatingAction;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GMeasurement() {
    }

    private GMeasurement(String expression, String figureName) {
        logger.info((Object)(expression + ", " + figureName));
        this.expression = expression;
        this.figureName = figureName;
    }

    public static GMeasurement newDistance(String[] labels, String figureName) {
        logger.info((Object)(Arrays.asList(labels) + ", " + figureName));
        String expression = "|" + labels[0] + labels[1] + "|";
        return new GMeasurement(expression, figureName);
    }

    public static GMeasurement newAngle(String[] labels, String figureName) {
        logger.info((Object)(Arrays.asList(labels) + ", " + figureName));
        String expression = "<" + labels[1] + labels[0] + labels[2];
        return new GMeasurement(expression, figureName);
    }

    public static GMeasurement newArea(String[] labels, String figureName) {
        logger.info((Object)(Arrays.asList(labels) + ", " + figureName));
        String expression = "area[" + labels[0] + labels[1] + labels[2] + "]";
        return new GMeasurement(expression, figureName);
    }

    public static GMeasurement newVolume(String figureName) {
        logger.info((Object)figureName);
        String expression = "volume";
        return new GMeasurement(expression, figureName);
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        String exp = node.getElementsByTagName("expression").item(0).getTextContent();
        this.expression = GStringUtils.fromXml(exp);
        this.figureName = node.getElementsByTagName("figureName").item(0).getTextContent();
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<measurement>");
        buf.append("\n<expression>");
        buf.append(GStringUtils.toXml(this.expression));
        buf.append("</expression>");
        buf.append("\n<figureName>");
        buf.append(this.figureName);
        buf.append("</figureName>");
        buf.append("\n</measurement>");
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public double getValue(GDocument document) throws Exception {
        GFigure figure = document.getFigure(this.figureName);
        if (figure == null) {
            logger.error((Object)("Figure: " + this.figureName));
            throw new Exception();
        }
        GSolid solid = figure.getSolid();
        Matcher matcher = DISTANCE_PATTERN.matcher(this.expression);
        if (matcher.matches()) {
            return this.getDistance(matcher, solid);
        }
        matcher = ANGLE_PATTERN.matcher(this.expression);
        if (matcher.matches()) {
            return this.getAngle(matcher, solid);
        }
        matcher = AREA_PATTERN.matcher(this.expression);
        if (matcher.matches()) {
            return this.getArea(matcher, solid);
        }
        matcher = VOLUME_PATTERN.matcher(this.expression);
        if (matcher.matches()) {
            return solid.computeVolume();
        }
        logger.error((Object)this);
        throw new Exception();
    }

    private double getDistance(Matcher matcher, GSolid solid) throws Exception {
        String[] labels = new String[]{matcher.group(1), matcher.group(2)};
        GPoint3d p1 = solid.getPoint(labels[0]);
        GPoint3d p2 = solid.getPoint(labels[1]);
        if (p1 == null || p2 == null) {
            logger.error((Object)this);
            throw new Exception();
        }
        double distance = p1.coords.distance(p2.coords);
        return distance;
    }

    private double getAngle(Matcher matcher, GSolid solid) throws Exception {
        String[] labels = new String[]{matcher.group(1), matcher.group(2), matcher.group(3)};
        GPoint3d p1 = solid.getPoint(labels[0]);
        GPoint3d p2 = solid.getPoint(labels[1]);
        GPoint3d p3 = solid.getPoint(labels[2]);
        if (p1 == null || p2 == null || p3 == null) {
            logger.error((Object)this);
            throw new Exception();
        }
        Vector3d v1 = new Vector3d((Tuple3d)p1.coords);
        v1.sub((Tuple3d)p2.coords);
        Vector3d v2 = new Vector3d((Tuple3d)p3.coords);
        v2.sub((Tuple3d)p2.coords);
        double angle = v1.angle(v2);
        return angle;
    }

    private double getArea(Matcher matcher, GSolid solid) throws Exception {
        String[] labels = new String[]{matcher.group(1), matcher.group(2), matcher.group(3)};
        Collection<GFace> faces = solid.facesThroughPoints(labels);
        if (faces.size() != 1) {
            logger.error((Object)this);
            throw new Exception();
        }
        double area = faces.iterator().next().computeArea(solid);
        return area;
    }

    public void figureRemoved(GRemoveFigureAction action) {
        if (this.deprecated) {
            return;
        }
        if (action.getFigureName().equals(this.figureName)) {
            this.deprecated = true;
            this.deprecatingAction = action;
            logger.info((Object)this);
        }
    }

    public void removeFigureUndone(GRemoveFigureAction action) {
        if (this.deprecated && this.deprecatingAction == action) {
            this.deprecated = false;
            logger.info((Object)this);
        }
    }

    public void figureRenamed(GRenameFigureAction action) {
        if (action.getOldFigureName().equals(this.figureName)) {
            logger.info((Object)this);
            this.figureName = action.getNewFigureName();
            logger.info((Object)this.figureName);
        }
    }

    public void renameFigureUndone(GRenameFigureAction action) {
        if (action.getNewFigureName().equals(this.figureName)) {
            logger.info((Object)this);
            this.figureName = action.getOldFigureName();
            logger.info((Object)this.figureName);
        }
    }

    public void pointRenamed(GRenamePointAction action) {
        if (this.deprecated) {
            return;
        }
        if (!action.getFigureName().equals(this.figureName)) {
            return;
        }
        String oldLabel = action.getOldLabel();
        String newLabel = action.getNewLabel();
        this.replaceLabel(oldLabel, newLabel);
    }

    public void renamePointUndone(GRenamePointAction action) {
        if (this.deprecated) {
            return;
        }
        if (!action.getFigureName().equals(this.figureName)) {
            return;
        }
        String oldLabel = action.getOldLabel();
        String newLabel = action.getNewLabel();
        this.replaceLabel(newLabel, oldLabel);
    }

    private void replaceLabel(String fromLabel, String toLabel) {
        String token;
        Map<Integer, String> labels = this.getLabels();
        StringBuffer buf = new StringBuffer();
        int expressionIndex = 0;
        for (int labelIndex : labels.keySet()) {
            if (labelIndex > expressionIndex) {
                token = this.expression.substring(expressionIndex, labelIndex);
                buf.append(token);
                expressionIndex += token.length();
            }
            if ((token = labels.get(labelIndex)).equals(fromLabel)) {
                token = toLabel;
            }
            buf.append(token);
            expressionIndex += token.length();
        }
        if (expressionIndex < this.expression.length()) {
            token = this.expression.substring(expressionIndex);
            buf.append(token);
        }
        this.expression = buf.toString();
    }

    public void lineErased(GEraseLineAction action) {
        if (this.deprecated) {
            return;
        }
        if (!action.getFigureName().equals(this.figureName)) {
            return;
        }
        List<GPoint3d> ps = action.getRemovedPoints();
        this.pointsRemoved(ps, action);
    }

    public void eraseLineUndone(GEraseLineAction action) {
        if (this.deprecated && this.deprecatingAction == action) {
            this.deprecated = false;
            logger.info((Object)this);
        }
    }

    public void selectionErased(GEraseSelectionAction action) {
        if (this.deprecated) {
            return;
        }
        if (!action.getFigureName().equals(this.figureName)) {
            return;
        }
        Collection<GPoint3d> ps = action.getRemovedPoints();
        this.pointsRemoved(ps, action);
    }

    public void eraseSelectionUndone(GEraseSelectionAction action) {
        if (this.deprecated && this.deprecatingAction == action) {
            this.deprecated = false;
            logger.info((Object)this);
        }
    }

    private Map<Integer, String> getLabels() {
        LinkedHashMap<Integer, String> labels = new LinkedHashMap<Integer, String>();
        Matcher matcher = DISTANCE_PATTERN.matcher(this.expression);
        if (matcher.matches()) {
            for (int i = 0; i < 2; ++i) {
                labels.put(matcher.start(i + 1), matcher.group(i + 1));
            }
            return labels;
        }
        matcher = ANGLE_PATTERN.matcher(this.expression);
        if (matcher.matches()) {
            for (int i = 0; i < 3; ++i) {
                labels.put(matcher.start(i + 1), matcher.group(i + 1));
            }
            return labels;
        }
        matcher = AREA_PATTERN.matcher(this.expression);
        matcher.matches();
        for (int i = 0; i < 3; ++i) {
            labels.put(matcher.start(i + 1), matcher.group(i + 1));
        }
        return labels;
    }

    private void pointsRemoved(Collection<GPoint3d> ps, GUndoable action) {
        for (GPoint3d p : ps) {
            String l = p.getLabel();
            Collection<String> labels = this.getLabels().values();
            if (!labels.contains(l)) continue;
            this.deprecated = true;
            this.deprecatingAction = action;
            logger.info((Object)this);
            return;
        }
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getFigureName() {
        return this.figureName;
    }

    public String getExpressionString() {
        if (this.expression.equals("volume")) {
            return GDictionary.get("volume", new String[0]);
        }
        if (this.expression.startsWith("area")) {
            return this.expression.replaceFirst("area", GDictionary.get("area", new String[0]));
        }
        return this.expression;
    }
}

