/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.action.GSolutionAnswerAction;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GLog
implements ListSelectionListener {
    private DefaultListModel model = new DefaultListModel();
    private ListSelectionModel selectionModel;
    private List<GLoggable> clonedActions;
    private boolean playing = false;
    private int currentPos = -1;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public void setSelectionModel(ListSelectionModel sm) {
        this.selectionModel = sm;
        this.selectionModel.setSelectionMode(0);
        this.selectionModel.addListSelectionListener(this);
    }

    public void add(GLoggable action) {
        this.model.addElement(action);
    }

    public void removeLast() {
        int index = this.model.size() - 1;
        logger.info((Object)index);
        this.model.remove(index);
    }

    public void startPlaying() {
        logger.info((Object)"");
        this.cloneActions();
        this.selectionModel.removeSelectionInterval(0, this.size() - 1);
        this.currentPos = -1;
        this.playing = true;
    }

    private void cloneActions() {
        this.clonedActions = new ArrayList<GLoggable>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            GLoggable action = this.actionAt(i).clone();
            this.clonedActions.add(action);
        }
    }

    public void stopPlaying() {
        logger.info((Object)"");
        this.selectionModel.removeSelectionInterval(0, this.size() - 1);
        this.playing = false;
    }

    public void setCurrentPos(int index) {
        logger.info((Object)index);
        this.selectionModel.removeSelectionInterval(0, this.size() - 1);
        this.selectionModel.setSelectionInterval(index, index);
    }

    public void advanceCurrentPos() {
        logger.info((Object)this.currentPos);
        this.selectionModel.removeSelectionInterval(this.currentPos, this.currentPos);
        this.selectionModel.setSelectionInterval(this.currentPos + 1, this.currentPos + 1);
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<log>");
        for (int i = 0; i < this.model.size(); ++i) {
            GLoggable action = (GLoggable)this.model.get(i);
            action.serialize(buf);
        }
        buf.append("\n</log>");
    }

    public void make(Element node) throws Exception {
        ListDataListener[] listeners;
        logger.info((Object)"");
        for (ListDataListener listener : listeners = (ListDataListener[])this.model.getListeners(ListDataListener.class)) {
            this.model.removeListDataListener(listener);
        }
        NodeList ns = node.getElementsByTagName("action");
        for (int i = 0; i < ns.getLength(); ++i) {
            GLoggable action;
            Element n = (Element)ns.item(i);
            String packageName = GLoggable.class.getPackage().getName();
            String cName = n.getElementsByTagName("className").item(0).getTextContent();
            String className = packageName + "." + cName;
            try {
                action = (GLoggable)Class.forName(className).newInstance();
            }
            catch (Exception exception) {
                logger.error((Object)GStringUtils.stackTraceToString(exception));
                throw exception;
            }
            action.make(n);
            this.add(action);
            if (action instanceof GSolutionAnswerAction) break;
        }
        for (ListDataListener listener : listeners) {
            this.model.addListDataListener(listener);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        String figureName;
        GLoggable action;
        int i;
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this.selectionModel.isSelectionEmpty()) {
            return;
        }
        logger.info((Object)("currentPos: " + this.currentPos));
        int newPos = this.selectionModel.getMinSelectionIndex();
        if (newPos == this.currentPos) {
            return;
        }
        if (!this.playing) {
            this.currentPos = newPos;
            return;
        }
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GSolution document = (GSolution)documentHandler.getActiveDocument();
        if (newPos > this.currentPos) {
            for (i = this.currentPos + 1; i <= newPos; ++i) {
                action = this.clonedActions.get(i);
                try {
                    action.execute(true);
                    continue;
                }
                catch (Exception exception) {
                    logger.error((Object)GStringUtils.stackTraceToString(exception));
                    return;
                }
            }
        } else {
            for (i = this.currentPos; i > newPos; --i) {
                action = this.clonedActions.get(i);
                action.undo(documentHandler);
            }
        }
        this.currentPos = newPos;
        GLoggable action2 = this.clonedActions.get(this.currentPos);
        if (action2 instanceof GFigureAction && (figureName = ((GFigureAction)((Object)action2)).getFigureName()) != null) {
            document.setSelectedFigure(figureName);
            documentHandler.figureSelectionChanged();
        }
        documentHandler.updateActionHandlerStates();
        logger.info((Object)("newPos: " + newPos));
    }

    public ListModel getModel() {
        return this.model;
    }

    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    public GLoggable actionAt(int index) {
        return (GLoggable)this.model.get(index);
    }

    public int indexOf(GLoggable action) {
        return this.model.indexOf(action);
    }

    public GLoggable actionAtCurrentPos() {
        if (this.currentPos < 0) {
            return null;
        }
        return this.actionAt(this.currentPos);
    }

    public int size() {
        return this.model.size();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public int getCurrentPos() {
        return this.currentPos;
    }
}

