/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLine {
    private List<String> labels;
    private GFace face;
    private GLine twin;

    public GLine() {
        this.labels = new ArrayList<String>();
    }

    public GLine(String label1, String label2) {
        this();
        this.labels.add(label1);
        this.labels.add(label2);
    }

    public GLine(GStick stick) {
        this(stick.label1, stick.label2);
    }

    public GLine(List<String> labels) {
        this.labels = labels;
    }

    public GLine(GLine line, int fromIndex, int toIndex) {
        this();
        for (int i = fromIndex; i <= toIndex; ++i) {
            this.labels.add(line.labelAt(i));
        }
    }

    public GLine(GLine line) {
        this(line, 0, line.labelCount() - 1);
    }

    public GLine clone() {
        GLine line = new GLine(this);
        return line;
    }

    public void serialize(StringBuffer buf) {
        buf.append("\n<line>");
        buf.append("\n<labels>");
        buf.append("\n<label>");
        buf.append(this.firstLabel());
        buf.append("</label>");
        buf.append("\n<label>");
        buf.append(this.lastLabel());
        buf.append("</label>");
        buf.append("\n</labels>");
        buf.append("\n</line>");
    }

    public int labelCount() {
        return this.labels.size();
    }

    public String labelAt(int i) {
        return this.labels.get(i);
    }

    public String firstLabel() {
        return this.labels.get(0);
    }

    public String lastLabel() {
        return this.labels.get(this.labels.size() - 1);
    }

    public boolean contains(String label) {
        return this.labels.contains(label);
    }

    public int indexOf(String label) {
        return this.labels.indexOf(label);
    }

    public void remove(String label) {
        this.labels.remove(label);
    }

    public double length(GSolid solid) {
        return solid.getPoint((String)this.firstLabel()).coords.distance(solid.getPoint((String)this.lastLabel()).coords);
    }

    public void reverse() {
        Collections.reverse(this.labels);
    }

    public GFace getFace() {
        return this.face;
    }

    public void setFace(GFace face) {
        this.face = face;
    }

    public void setTwin(GLine twin) {
        this.twin = twin;
    }

    public GLine getTwin() {
        return this.twin;
    }

    public boolean acquire(GPoint3d p, GSolid solid) {
        Point3d coords1 = solid.getPoint((String)this.firstLabel()).coords;
        Point3d coords2 = solid.getPoint((String)this.lastLabel()).coords;
        Point3d projection = GMath.project(p.coords, coords1, coords2);
        if (projection.distance(p.coords) > solid.getEpsilon()) {
            return false;
        }
        return this.insert(p, solid);
    }

    public boolean insert(GPoint3d p, GSolid solid) {
        double epsilon = solid.getEpsilon();
        if (solid.getPoint((String)this.firstLabel()).coords.distance(p.coords) < epsilon) {
            return false;
        }
        for (int i = 0; i < this.labels.size() - 1; ++i) {
            Point3d pPrev = solid.getPoint((String)this.labels.get((int)i)).coords;
            Point3d pNext = solid.getPoint((String)this.labels.get((int)(i + 1))).coords;
            if (pNext.distance(p.coords) < epsilon) {
                return false;
            }
            Vector3d ppPrev = new Vector3d();
            ppPrev.sub((Tuple3d)pPrev, (Tuple3d)p.coords);
            Vector3d ppNext = new Vector3d();
            ppNext.sub((Tuple3d)pNext, (Tuple3d)p.coords);
            if (!(ppNext.dot(ppPrev) < 0.0)) continue;
            this.labels.add(i + 1, p.getLabel());
            return true;
        }
        return false;
    }

    public void addPoint(GPoint3d p, GSolid solid) {
        double k = GMath.simpleRatio(solid.getPoint((String)this.firstLabel()).coords, solid.getPoint((String)this.lastLabel()).coords, p.coords);
        if (k > 0.0) {
            this.insert(p, solid);
        } else if (k > -1.0) {
            this.labels.add(0, p.getLabel());
        } else {
            this.labels.add(p.getLabel());
        }
    }

    public boolean acquire(GLine line, GSolid solid) {
        double epsilon = solid.getEpsilon();
        Point3d p1 = solid.getPoint((String)this.firstLabel()).coords;
        Point3d p2 = solid.getPoint((String)this.lastLabel()).coords;
        Point3d p3 = solid.getPoint((String)line.firstLabel()).coords;
        Point3d p4 = solid.getPoint((String)line.lastLabel()).coords;
        Point3d pr3 = GMath.project(p3, p1, p2);
        if (pr3.distance(p3) > epsilon) {
            return false;
        }
        Point3d pr4 = GMath.project(p4, p1, p2);
        if (pr4.distance(p4) > epsilon) {
            return false;
        }
        double k3 = -GMath.simpleRatio(p3, p2, p1);
        double k4 = -GMath.simpleRatio(p4, p2, p1);
        if (k3 < -1.0E-7 && k4 < -1.0E-7) {
            return false;
        }
        if (k3 > 1.0000001 && k4 > 1.0000001) {
            return false;
        }
        if (k3 < -1.0E-7) {
            this.labels.add(0, line.firstLabel());
        } else if (k3 > 1.0000001) {
            this.labels.add(line.firstLabel());
        } else {
            this.insert(solid.getPoint(line.firstLabel()), solid);
        }
        if (k4 < -1.0E-7) {
            this.labels.add(0, line.lastLabel());
        } else if (k4 > 1.0000001) {
            this.labels.add(line.lastLabel());
        } else {
            this.insert(solid.getPoint(line.lastLabel()), solid);
        }
        for (int i = 1; i < line.labelCount() - 1; ++i) {
            GPoint3d p = solid.getPoint(line.labelAt(i));
            this.insert(p, solid);
        }
        return true;
    }

    public Vector3d toVector(GSolid solid) {
        Vector3d v = new Vector3d((Tuple3d)solid.getPoint((String)this.lastLabel()).coords);
        v.sub((Tuple3d)solid.getPoint((String)this.firstLabel()).coords);
        return v;
    }

    public GPoint3d getPoint(Point3d coords, GSolid solid) {
        double epsilon = solid.getEpsilon();
        for (String label : this.labels) {
            GPoint3d p = solid.getPoint(label);
            if (!p.coords.epsilonEquals((Tuple3d)coords, epsilon)) continue;
            return p;
        }
        return null;
    }

    public void pointRenamed(String oldLabel, String newLabel) {
        for (int i = 0; i < this.labels.size(); ++i) {
            String label = this.labels.get(i);
            if (!label.equals(oldLabel)) continue;
            this.labels.remove(i);
            this.labels.add(i, newLabel);
            return;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        for (String label : this.labels) {
            buf.append(label);
        }
        buf.append("]");
        return String.valueOf(buf);
    }
}

