/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.geocentral.geometria.model.LabelComparator;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLabelFactory {
    public static final String VARIABLE_CHARSET = "a-zA-Z\\p{InCyrillic}_";
    public static final String VARIABLE_NAME_PATTERN = "[a-zA-Z\\p{InCyrillic}_][0-9a-zA-Z\\p{InCyrillic}_]*";
    public static final String LABEL_PATTERN = "[A-Z][0-9]*";
    private final Pattern pattern = Pattern.compile("([A-Z])([0-9]*)");
    private static GLabelFactory instance;
    private static Logger logger;

    private GLabelFactory() {
    }

    public static GLabelFactory getInstance() {
        if (instance == null) {
            instance = new GLabelFactory();
        }
        return instance;
    }

    public String createLabel(Collection<String> labels) {
        logger.info((Object)"");
        String[] labelList = new String[labels.size()];
        labels.toArray(labelList);
        Arrays.sort(labelList, new LabelComparator());
        String label = this.nextLabel(labelList[labelList.length - 1]);
        logger.info((Object)label);
        return label;
    }

    public String nextLabel(String label) {
        String suffix;
        if (label == null) {
            return "A";
        }
        Matcher matcher = this.pattern.matcher(label);
        matcher.matches();
        char prefix = matcher.group(1).charAt(0);
        String string = suffix = matcher.groupCount() == 1 ? "" : matcher.group(2);
        if (prefix != 'Z') {
            prefix = (char)(prefix + '\u0001');
            return prefix + suffix;
        }
        suffix = suffix.length() == 0 ? "1" : String.valueOf(Integer.parseInt(suffix) + 1);
        return "A" + suffix;
    }

    public void validateLabel(String label) throws Exception {
        if (!label.matches(LABEL_PATTERN)) {
            logger.error((Object)label);
            throw new Exception();
        }
    }

    public String newFigureName(List<String> figureNames) {
        logger.info(figureNames);
        String prefix = GDictionary.get("Figure", new String[0]);
        int prefixLength = prefix.length();
        ArrayList<Integer> suffixes = new ArrayList<Integer>();
        for (String name : figureNames) {
            if (!name.startsWith(prefix) || name.length() <= prefixLength) continue;
            String s = name.substring(prefixLength);
            suffixes.add(Integer.parseInt(s));
        }
        Collections.sort(suffixes);
        int suffix = suffixes.isEmpty() ? 1 : (Integer)suffixes.get(suffixes.size() - 1) + 1;
        String figureName = prefix + suffix;
        logger.info((Object)figureName);
        return figureName;
    }

    static {
        logger = Logger.getLogger((String)"net.geocentral.geometria");
    }
}

