/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.event.ChangeListener;
import net.geocentral.geometria.model.GCamera;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GXmlEntity;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.view.GFigurePane;
import net.geocentral.geometria.view.GFigurePopupMenu;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GFigure
implements Cloneable {
    public static final Color DEFAULT_COLOR = Color.CYAN.brighter();
    public static final double ZOOM_FACTOR = Math.sqrt(2.0);
    public static final double MARGIN_FACTOR = 1.2;
    private String name;
    private boolean transparent = true;
    private boolean labelled = true;
    private GSolid solid;
    private GCamera camera;
    private Color baseColor = DEFAULT_COLOR;
    private double scalingFactor = -1.0;
    private double initZoomFactor = 1.0;
    private boolean selected;
    private boolean painting;
    private GFigurePane pane;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GFigure() {
        this.camera = new GCamera();
    }

    public GFigure(GSolid solid) {
        this();
        this.solid = solid;
    }

    public GFigure(GSolid solid, double initZoomFactor) {
        this(solid);
        this.initZoomFactor = initZoomFactor;
    }

    public GFigure clone() {
        logger.info((Object)this);
        GFigure figure = new GFigure();
        figure.name = this.name;
        figure.transparent = this.transparent;
        figure.labelled = this.labelled;
        figure.solid = this.solid.clone();
        figure.camera = this.camera.clone();
        figure.baseColor = new Color(this.baseColor.getRGB());
        figure.scalingFactor = -1.0;
        return figure;
    }

    public void make(Element node, GXmlEntity parent) throws Exception {
        logger.info((Object)"");
        this.makeName(node);
        this.makeColor(node);
        this.makeTransparent(node);
        this.makeLabelled(node);
        this.makeSolid(node, parent);
        this.makeCamera(node);
    }

    private void makeName(Element node) throws Exception {
        logger.info((Object)"");
        this.name = node.getElementsByTagName("name").item(0).getTextContent();
    }

    private void makeColor(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("color");
        if (ns.getLength() > 0) {
            this.baseColor = Color.decode(ns.item(0).getTextContent());
        }
    }

    private void makeTransparent(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("transparent");
        if (ns.getLength() > 0) {
            this.transparent = Boolean.parseBoolean(ns.item(0).getTextContent());
        }
    }

    private void makeLabelled(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("labelled");
        if (ns.getLength() > 0) {
            this.labelled = Boolean.parseBoolean(ns.item(0).getTextContent());
        }
    }

    private void makeSolid(Element node, GXmlEntity parent) throws Exception {
        logger.info((Object)"");
        Element n = (Element)node.getElementsByTagName("solid").item(0);
        this.solid = new GSolid();
        this.solid.make(n, parent);
    }

    private void makeCamera(Element node) throws Exception {
        logger.info((Object)"");
        Element n = (Element)node.getElementsByTagName("camera").item(0);
        this.camera.make(n);
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<figure>");
        buf.append("\n<name>");
        buf.append(this.name);
        buf.append("</name>");
        buf.append("\n<color>");
        buf.append("#" + this.getHexBaseColor());
        buf.append("</color>");
        buf.append("\n<transparent>");
        buf.append(String.valueOf(this.transparent));
        buf.append("</transparent>");
        buf.append("\n<labelled>");
        buf.append(String.valueOf(this.labelled));
        buf.append("</labelled>");
        this.solid.serialize(buf);
        this.camera.serialize(buf);
        buf.append("\n</figure>");
    }

    private void setPreferredSize() {
        logger.info((Object)"");
        int span = 2 * (int)(this.scalingFactor * this.solid.getBoundingSphere().getRadius() * 1.2);
        this.pane.setPreferredSize(new Dimension(span, span));
        logger.info((Object)span);
    }

    private void scalingFactorToView() {
        logger.info((Object)"");
        double radius = this.solid.getBoundingSphere().getRadius();
        Dimension viewSize = this.pane.getViewSize();
        this.scalingFactor = 0.5 * Math.min((double)viewSize.width / radius, (double)viewSize.height / radius) / 1.2;
        logger.info((Object)this.scalingFactor);
    }

    public void cameraTurned() {
        if (!this.painting) {
            this.repaint();
        }
    }

    public void zoomIn() {
        logger.info((Object)"");
        this.zoom(ZOOM_FACTOR);
        logger.info((Object)this.scalingFactor);
    }

    public void zoomOut() {
        logger.info((Object)"");
        this.zoom(1.0 / ZOOM_FACTOR);
        logger.info((Object)this.scalingFactor);
    }

    private void zoom(double factor) {
        ChangeListener[] listeners = this.pane.removeChangeListeners();
        this.pane.repositionViewport(factor);
        this.scalingFactor *= factor;
        this.setPreferredSize();
        this.pane.addChangeListeners(listeners);
        this.pane.revalidate();
    }

    public void fitToView() {
        logger.info((Object)"");
        this.scalingFactorToView();
        this.setPreferredSize();
        this.pane.revalidate();
        this.repaint();
    }

    public void toggleTransparency() {
        this.transparent ^= true;
        logger.info((Object)this.transparent);
        this.repaint();
    }

    public void toggleLabels() {
        this.labelled ^= true;
        logger.info((Object)this.labelled);
        this.repaint();
    }

    public void setBaseColor(Color baseColor) {
        logger.info((Object)baseColor);
        this.baseColor = baseColor;
        this.repaint();
    }

    public void initialAttitude() {
        logger.info((Object)"");
        this.camera.seize();
        this.camera.toInitialAttitude();
        this.repaint();
    }

    public void defaultAttitude() {
        logger.info((Object)"");
        this.camera.seize();
        this.camera.toDefaultAttitude();
        this.repaint();
    }

    public void print() throws Exception {
        logger.info((Object)"");
        PrinterJob job = PrinterJob.getPrinterJob();
        Printer printer = new Printer();
        job.setPrintable(printer);
        if (job.printDialog()) {
            try {
                job.print();
                logger.info((Object)this.name);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
                throw new Exception();
            }
        }
    }

    public void paint(Graphics2D g2d) {
        this.painting = true;
        g2d.setFont(GGraphicsFactory.getFigureFont());
        if (this.scalingFactor < 0.0) {
            this.scalingFactorToView();
            this.zoom(this.initZoomFactor);
        }
        if (this.transparent) {
            this.solid.paintTransparent(g2d, this.camera, this.scalingFactor, this.pane.getSize(), this.labelled);
        } else {
            this.solid.paintOpaque(g2d, this.camera, this.scalingFactor, this.pane.getSize(), this.baseColor, this.labelled);
        }
        this.painting = false;
    }

    public void repaint() {
        if (this.pane != null) {
            this.pane.repaint();
        }
    }

    public void setSelected(boolean selected) {
        logger.info((Object)(this + ", " + selected));
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GSolid getSolid() {
        return this.solid;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public boolean isLabelled() {
        return this.labelled;
    }

    public void setLabelled(boolean labelled) {
        this.labelled = labelled;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    private String getHexBaseColor() {
        return Integer.toHexString((this.baseColor.getRed() * 256 + this.baseColor.getGreen()) * 256 + this.baseColor.getBlue());
    }

    public void select(MouseEvent e) {
        double xp = ((double)e.getX() - 0.5 * (double)this.pane.getWidth()) / this.scalingFactor;
        double yp = (0.5 * (double)this.pane.getHeight() - (double)e.getY()) / this.scalingFactor;
        this.solid.select(xp, yp, this.scalingFactor, e.isControlDown(), this.transparent, this.camera);
        this.repaint();
    }

    public void popupMenu(int x, int y) {
        GFigurePopupMenu popup = new GFigurePopupMenu(this);
        popup.show(this.pane, x, y);
    }

    public BufferedImage exportImage() {
        int width = this.pane.getWidth();
        int height = this.pane.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2 = image.createGraphics();
        this.pane.paint(g2);
        return image;
    }

    public void setPane(GFigurePane pane) {
        this.pane = pane;
    }

    public GCamera getCamera() {
        return this.camera;
    }

    public void setCamera(GCamera camera) {
        this.camera = camera;
    }

    public String toString() {
        return this.name;
    }

    class Printer
    implements Printable {
        Printer() {
        }

        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex > 0) {
                return 1;
            }
            ((Graphics2D)g).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            GFigure.this.pane.printAll(g);
            return 0;
        }
    }
}

