/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.model.GCamera;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFace
implements Cloneable,
GSelectable {
    private int sideCount;
    private List<GLine> lines;

    public GFace() {
        this.lines = new ArrayList<GLine>();
    }

    public GFace(int sideCount, List<GLine> lines) {
        this.sideCount = sideCount;
        this.lines = lines;
    }

    public GFace clone() {
        GFace face = new GFace();
        face.sideCount = this.sideCount;
        for (GLine line : this.lines) {
            GLine l = line.clone();
            face.lines.add(l);
        }
        return face;
    }

    public boolean contains(String label) {
        for (GLine line : this.lines) {
            if (!line.contains(label)) continue;
            return true;
        }
        return false;
    }

    public String labelAt(int index) {
        return this.lines.get(index).firstLabel();
    }

    public boolean containsLine(GLine line) {
        return this.lines.contains(line);
    }

    public boolean containsSide(GLine line) {
        int index = this.lines.indexOf(line);
        return index < this.sideCount;
    }

    public int sideCount() {
        return this.sideCount;
    }

    public int lineCount() {
        return this.lines.size();
    }

    public GLine lineAt(int index) {
        return this.lines.get(index);
    }

    public void paintOpaque(Graphics2D g2d, Color baseColor, GCamera camera, Set<GSelectable> selection, GSolid solid, Point3d refPoint) {
        int i;
        Polygon polygon = new Polygon();
        for (i = 0; i < this.sideCount; ++i) {
            Point p = solid.getPoint((String)this.labelAt((int)i)).scrCoords;
            polygon.addPoint(p.x, p.y);
        }
        if (selection.contains(this)) {
            g2d.setColor(GSolid.SELECTION_COLOR);
            g2d.fill(polygon);
        } else {
            Vector3d on = this.getNormal(solid, refPoint);
            camera.getAttitude().transform((Tuple3d)on);
            Color color = GPainter.getInstance().getHue(baseColor, on.z);
            g2d.setColor(color);
            g2d.fill(polygon);
        }
        for (i = 0; i < this.lines.size(); ++i) {
            GLine line = this.lines.get(i);
            Point p1 = solid.getPoint((String)line.firstLabel()).scrCoords;
            Point p2 = solid.getPoint((String)line.lastLabel()).scrCoords;
            GStick stick = new GStick(line);
            if (selection.contains(stick)) {
                g2d.setColor(GSolid.SELECTION_COLOR);
                g2d.setStroke(GSolid.SELECTION_STROKE);
                g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
            } else if (i >= this.sideCount) {
                g2d.setColor(GSolid.OPAQUE_LINE_COLOR);
                g2d.setStroke(GSolid.SOLID_STROKE);
                g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
            for (int j = 0; j < line.labelCount(); ++j) {
                GPoint3d p = solid.getPoint(line.labelAt(j));
                if (!selection.contains(p)) continue;
                g2d.setColor(GSolid.SELECTION_COLOR);
                g2d.fillOval(p.scrCoords.x - 4, p.scrCoords.y - 4, 8, 8);
            }
        }
    }

    public Vector3d getNormal(GSolid solid) {
        Vector3d normal = new Vector3d();
        Point3d p1 = solid.getPoint((String)this.labelAt((int)0)).coords;
        Point3d p2 = solid.getPoint((String)this.labelAt((int)1)).coords;
        Point3d p3 = solid.getPoint((String)this.labelAt((int)2)).coords;
        Vector3d edge1 = new Vector3d();
        edge1.sub((Tuple3d)p2, (Tuple3d)p1);
        Vector3d edge2 = new Vector3d();
        edge2.sub((Tuple3d)p3, (Tuple3d)p2);
        normal.cross(edge1, edge2);
        normal.normalize();
        return normal;
    }

    public int getOrientation(GSolid solid, Point3d refPoint) {
        Point3d p0 = solid.getPoint((String)this.labelAt((int)0)).coords;
        Point3d p1 = solid.getPoint((String)this.labelAt((int)1)).coords;
        Point3d p2 = solid.getPoint((String)this.labelAt((int)2)).coords;
        return GMath.getOrientation(p0, p1, p2, refPoint);
    }

    public Vector3d getNormal(GSolid solid, Point3d refPoint) {
        Vector3d normal = this.getNormal(solid);
        Point3d p1 = solid.getPoint((String)this.labelAt((int)0)).coords;
        Vector3d toOutside = new Vector3d();
        toOutside.sub((Tuple3d)p1, (Tuple3d)refPoint);
        if (normal.dot(toOutside) < 0.0) {
            normal.scale(-1.0);
        }
        return normal;
    }

    public boolean covers(Point3d p, GSolid solid) {
        double epsilon = solid.getEpsilon();
        for (int i = 0; i < this.sideCount; ++i) {
            GLine line = this.lines.get(i);
            if (!GMath.isBetween(p, solid.getPoint((String)line.firstLabel()).coords, solid.getPoint((String)line.lastLabel()).coords, epsilon)) continue;
            return true;
        }
        Vector3d v1 = GMath.cross(p, solid.getPoint((String)this.labelAt((int)0)).coords, solid.getPoint((String)this.labelAt((int)1)).coords);
        v1.normalize();
        for (int i = 1; i < this.sideCount; ++i) {
            GLine line = this.lines.get(i);
            Vector3d vi = GMath.cross(p, solid.getPoint((String)line.firstLabel()).coords, solid.getPoint((String)line.lastLabel()).coords);
            vi.normalize();
            if (!(vi.dot(v1) < -1.0E-7)) continue;
            return false;
        }
        return true;
    }

    public GLine lineThroughPoints(String label1, String label2) {
        for (GLine line : this.lines) {
            if (!line.contains(label1) || !line.contains(label2)) continue;
            return line;
        }
        return null;
    }

    public List<GLine> linesThroughPoint(String label) {
        ArrayList<GLine> ls = new ArrayList<GLine>();
        for (GLine line : this.lines) {
            if (!line.contains(label)) continue;
            ls.add(line);
        }
        return ls;
    }

    public GLine getLineAt(double xp, double yp, double selectTolerance, Map<String, GPoint3d> pointMap) {
        for (GLine line : this.lines) {
            GPoint3d p1 = pointMap.get(line.firstLabel());
            GPoint3d p2 = pointMap.get(line.lastLabel());
            double dist = Line2D.ptSegDist(p1.projCoords.x, p1.projCoords.y, p2.projCoords.x, p2.projCoords.y, xp, yp);
            if (!(dist < selectTolerance)) continue;
            return line;
        }
        return null;
    }

    public Object getElementAt(double xp, double yp, double tolerance, Map<String, GPoint3d> pointMap) {
        GLine line = this.getLineAt(xp, yp, tolerance, pointMap);
        if (line != null) {
            GPoint3d p1 = pointMap.get(line.firstLabel());
            GPoint3d p2 = pointMap.get(line.lastLabel());
            if (Point2D.distance(p1.projCoords.x, p1.projCoords.y, xp, yp) < tolerance) {
                return p1;
            }
            if (Point2D.distance(p2.projCoords.x, p2.projCoords.y, xp, yp) < tolerance) {
                return p2;
            }
            return line;
        }
        Iterator<GLine> it = this.lines.iterator();
        Double firstDet = null;
        for (int i = 0; i < this.sideCount; ++i) {
            line = it.next();
            Point2d p1 = pointMap.get((Object)line.firstLabel()).projCoords;
            Point2d p2 = pointMap.get((Object)line.lastLabel()).projCoords;
            double det = (xp - p1.x) * (yp - p2.y) - (xp - p2.x) * (yp - p1.y);
            if (firstDet == null) {
                firstDet = det;
                continue;
            }
            if (!(firstDet * det <= 0.0)) continue;
            return null;
        }
        return this;
    }

    public boolean addPoint(GPoint3d p, GSolid solid) {
        boolean added = false;
        for (GLine line : this.lines) {
            added = added || line.acquire(p, solid);
        }
        return added;
    }

    public void removePoint(GPoint3d p) {
        for (GLine line : this.lines) {
            line.remove(p.getLabel());
        }
    }

    public GLine addLine(GPoint3d p1, GPoint3d p2, List<GLine> removedLines, GSolid solid) {
        GLine l3;
        for (int i = 0; i < this.sideCount; ++i) {
            GLine l2 = this.lines.get(i);
            if (!l2.contains(p1.getLabel()) || !l2.contains(p2.getLabel())) continue;
            return null;
        }
        GLine line = new GLine(p1.getLabel(), p2.getLabel());
        for (int i = this.sideCount; i < this.lines.size(); ++i) {
            l3 = this.lines.get(i);
            if (!line.acquire(l3, solid)) continue;
            removedLines.add(l3);
        }
        for (GLine l3 : removedLines) {
            this.lines.remove(l3);
        }
        for (int i = this.sideCount; i < this.lines.size(); ++i) {
            l3 = this.lines.get(i);
            for (int j = 0; j < l3.labelCount(); ++j) {
                GPoint3d p = solid.getPoint(l3.labelAt(j));
                line.acquire(p, solid);
            }
        }
        this.lines.add(line);
        return line;
    }

    public void undoAddLine(GLine addedLine, List<GLine> removedLines) {
        if (addedLine != null) {
            this.lines.remove(addedLine);
        }
        for (GLine line : removedLines) {
            this.lines.add(line);
        }
    }

    public void undoAddLines(List<GLine> addedLines, List<GLine> removedLines) {
        for (GLine line : addedLines) {
            this.lines.remove(line);
        }
        for (GLine line : removedLines) {
            this.lines.add(line);
        }
    }

    public void addLine(GLine line) {
        this.lines.add(line);
    }

    public GLine removeLine(GPoint3d p1, GPoint3d p2, List<GLine> addedLines, List<String> removedLabels) {
        String label;
        int i;
        String label1 = p1.getLabel();
        String label2 = p2.getLabel();
        GLine line = this.lineThroughPoints(label1, label2);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (i = 0; i < line.labelCount(); ++i) {
            label = line.labelAt(i);
            if (label.equals(label1) || label.equals(label2)) {
                indices.add(i);
            }
            if (indices.size() == 2) break;
        }
        if ((Integer)indices.get(0) > 0) {
            GLine l = new GLine(line, 0, (Integer)indices.get(0));
            addedLines.add(l);
            this.lines.add(l);
        }
        if ((Integer)indices.get(1) < line.labelCount() - 1) {
            GLine l = new GLine(line, (Integer)indices.get(1), line.labelCount() - 1);
            addedLines.add(l);
            this.lines.add(l);
        }
        for (i = ((Integer)indices.get(0)).intValue(); i <= (Integer)indices.get(1); ++i) {
            label = line.labelAt(i);
            if (this.linesThroughPoint(label).size() >= 2) continue;
            removedLabels.add(label);
        }
        this.lines.remove(line);
        return line;
    }

    public void undoRemoveLine(GLine removedLine, List<GLine> addedLines) {
        this.lines.add(removedLine);
        for (GLine line : addedLines) {
            this.lines.remove(line);
        }
    }

    public void removeLine(GLine line, List<String> danglingLabels) {
        for (int i = 0; i < line.labelCount(); ++i) {
            String label = line.labelAt(i);
            if (this.linesThroughPoint(label).size() >= 2) continue;
            danglingLabels.add(label);
        }
        this.lines.remove(line);
    }

    public Object[] intersectRay(Point3d p, Vector3d v, GSolid solid) {
        double epsilon = solid.getEpsilon();
        Point3d pv = new Point3d(p);
        pv.add((Tuple3d)v);
        for (int i = 0; i < this.sideCount; ++i) {
            GLine line = this.lineAt(i);
            Point3d p1 = solid.getPoint((String)line.firstLabel()).coords;
            Point3d p2 = solid.getPoint((String)line.lastLabel()).coords;
            Point3d p3 = GMath.intersect(p, pv, p1, p2, epsilon);
            if (p3 == null || !GMath.isBetween(p3, p1, p2, epsilon)) continue;
            Vector3d v3 = new Vector3d((Tuple3d)p3);
            v3.sub((Tuple3d)p);
            if (!(v3.length() > epsilon) || !GMath.areCooriented(v3, v, epsilon)) continue;
            return new Object[]{line, p3};
        }
        return null;
    }

    public List<Point3d> intersectPlane(Point3d p, Vector3d n, GSolid solid) {
        ArrayList<Point3d> ps = new ArrayList<Point3d>();
        for (int i = 0; i < this.sideCount; ++i) {
            GLine line = this.lineAt(i);
            Point3d p1 = solid.getPoint((String)line.firstLabel()).coords;
            Point3d p2 = solid.getPoint((String)line.lastLabel()).coords;
            boolean p1InPlane = GMath.isInPlane(p1, p, n);
            boolean p2InPlane = GMath.isInPlane(p2, p, n);
            if (!p1InPlane && !p2InPlane) {
                Point3d p3 = GMath.intersectPlane(p1, p2, p, n);
                if (p3 != null) {
                    ps.add(p3);
                }
            } else if (p1InPlane && !ps.contains(p1)) {
                ps.add(p1);
            } else if (p2InPlane && !ps.contains(p2)) {
                ps.add(p2);
            }
            if (ps.size() != 2) continue;
            return ps;
        }
        return ps;
    }

    public boolean liesInPlane(Point3d p0, Vector3d n, GSolid solid) {
        Point3d p1 = solid.getPoint((String)this.lineAt((int)0).firstLabel()).coords;
        Point3d p2 = solid.getPoint((String)this.lineAt((int)0).lastLabel()).coords;
        Point3d p3 = solid.getPoint((String)this.lineAt((int)1).lastLabel()).coords;
        return GMath.isInPlane(p1, p0, n) && GMath.isInPlane(p2, p0, n) && GMath.isInPlane(p3, p0, n);
    }

    public Point3d computeGCenter(GSolid solid) {
        Point3d gCenter = new Point3d();
        for (int i = 0; i < this.sideCount; ++i) {
            GLine line = this.lines.get(i);
            gCenter.add((Tuple3d)solid.getPoint((String)line.firstLabel()).coords);
        }
        gCenter.scale(1.0 / (double)this.sideCount);
        return gCenter;
    }

    public double computeArea(GSolid solid) {
        double area = 0.0;
        Point3d gCenter = this.computeGCenter(solid);
        for (int i = 0; i < this.sideCount; ++i) {
            GLine line = this.lines.get(i);
            Point3d p1 = solid.getPoint((String)line.firstLabel()).coords;
            Point3d p2 = solid.getPoint((String)line.lastLabel()).coords;
            area += GMath.area(p1, p2, gCenter);
        }
        return area;
    }

    private List<Double> getSideLengths(GSolid solid) {
        ArrayList<Double> sideLengths = new ArrayList<Double>();
        for (int i = 0; i < this.sideCount; ++i) {
            GLine line = this.lineAt(i);
            sideLengths.add(line.length(solid));
        }
        return sideLengths;
    }

    private List<Double> getCosines(GSolid solid) {
        ArrayList<Double> cosines = new ArrayList<Double>();
        for (int i = 0; i < this.sideCount; ++i) {
            GLine line1 = this.lineAt(i);
            GLine line2 = this.lineAt((this.sideCount + i - 1) % this.sideCount);
            Vector3d v1 = new Vector3d((Tuple3d)solid.getPoint((String)line1.firstLabel()).coords);
            v1.sub((Tuple3d)solid.getPoint((String)line1.lastLabel()).coords);
            Vector3d v2 = new Vector3d((Tuple3d)solid.getPoint((String)line2.lastLabel()).coords);
            v2.sub((Tuple3d)solid.getPoint((String)line2.firstLabel()).coords);
            cosines.add(v1.dot(v2) / (v1.length() * v2.length()));
        }
        return cosines;
    }

    public List<Integer> match(GFace face1, boolean flipFace1, GSolid solid, GSolid solid1) {
        List<Double> sideLengths = this.getSideLengths(solid);
        List<Double> sideLengths1 = face1.getSideLengths(solid1);
        double min = Collections.min(sideLengths);
        double min1 = Collections.min(sideLengths1);
        double scaleFactor = min / min1;
        for (int i = 0; i < sideLengths1.size(); ++i) {
            sideLengths1.set(i, sideLengths1.get(i) * scaleFactor);
        }
        double epsilon = min * 1.0E-7;
        double max = Collections.max(sideLengths);
        double max1 = Collections.max(sideLengths1);
        if (Math.abs(max1 - max) > epsilon) {
            return new ArrayList<Integer>();
        }
        List<Integer> matchIndexes = GMath.matchCircular(sideLengths, sideLengths1, flipFace1, epsilon);
        if (matchIndexes.isEmpty()) {
            return matchIndexes;
        }
        List<Double> cosines = this.getCosines(solid);
        List<Double> cosines1 = face1.getCosines(solid1);
        ArrayList<Integer> badIndexes = new ArrayList<Integer>();
        for (int index : matchIndexes) {
            boolean indexIsBad = false;
            for (int i = 0; i < this.sideCount; ++i) {
                boolean match;
                if (!flipFace1) {
                    match = Math.abs(cosines1.get(i) - cosines.get((index + i) % this.sideCount)) < 1.0E-7;
                } else {
                    boolean bl = match = Math.abs(cosines1.get((this.sideCount - i) % this.sideCount) - cosines.get((index + i) % this.sideCount)) < 1.0E-7;
                }
                if (match) continue;
                indexIsBad = true;
                break;
            }
            if (!indexIsBad) continue;
            badIndexes.add(index);
        }
        matchIndexes.removeAll(badIndexes);
        return matchIndexes;
    }

    public int indexOf(GLine line) {
        return this.lines.indexOf(line);
    }

    public void cutOff(GLine line, Vector3d n, Set<GPoint3d> toBeRemovedPoints, GSolid solid) {
        Point3d coordsL2;
        Point3d coordsL1;
        GLine l;
        int i;
        double epsilon = solid.getEpsilon();
        Point3d coordsLine1 = solid.getPoint((String)line.firstLabel()).coords;
        Point3d coordsLine2 = solid.getPoint((String)line.lastLabel()).coords;
        ArrayList<GLine> ls = new ArrayList<GLine>();
        for (int i2 = 0; i2 < this.sideCount; ++i2) {
            Vector3d v;
            GLine l2 = this.lineAt(i2);
            Point3d coordsL12 = solid.getPoint((String)l2.firstLabel()).coords;
            Point3d coordsL22 = solid.getPoint((String)l2.lastLabel()).coords;
            Point3d coords = GMath.intersect(coordsL12, coordsL22, coordsLine1, coordsLine2, epsilon);
            int pIndex = -1;
            if (coords != null) {
                if (l2.firstLabel().equals(line.firstLabel()) || l2.firstLabel().equals(line.lastLabel())) {
                    pIndex = 0;
                } else if (l2.lastLabel().equals(line.firstLabel()) || l2.lastLabel() == line.lastLabel()) {
                    pIndex = l2.labelCount() - 1;
                } else if (GMath.isBetween(coords, coordsL12, coordsL22, epsilon)) {
                    for (int j = 0; j < l2.labelCount(); ++j) {
                        if (!solid.getPoint((String)l2.labelAt((int)j)).coords.epsilonEquals((Tuple3d)coords, epsilon)) continue;
                        pIndex = j;
                        break;
                    }
                }
            }
            if (pIndex < 0) {
                v = new Vector3d((Tuple3d)coordsL12);
                v.sub((Tuple3d)coordsLine1);
                if (v.dot(n) > 0.0) {
                    for (int j = 0; j < l2.labelCount() - 1; ++j) {
                        toBeRemovedPoints.add(solid.getPoint(l2.labelAt(j)));
                    }
                    continue;
                }
                GLine ll = l2.clone();
                ls.add(ll);
                continue;
            }
            v = new Vector3d((Tuple3d)coordsL22);
            v.sub((Tuple3d)coordsL12);
            if (v.dot(n) > 0.0) {
                for (int j = pIndex + 1; j < l2.labelCount(); ++j) {
                    toBeRemovedPoints.add(solid.getPoint(l2.labelAt(j)));
                }
                if (pIndex > 0) {
                    GLine ll = new GLine(l2, 0, pIndex);
                    ls.add(ll);
                }
                if (pIndex <= 0) continue;
                ls.add(line);
                continue;
            }
            for (int j = 0; j < pIndex; ++j) {
                toBeRemovedPoints.add(solid.getPoint(l2.labelAt(j)));
            }
            if (pIndex >= l2.labelCount() - 1) continue;
            GLine ll = new GLine(l2, pIndex, l2.labelCount() - 1);
            ls.add(ll);
        }
        int sc = ls.size();
        for (i = this.sideCount; i < this.lineCount(); ++i) {
            Point3d coords;
            l = this.lineAt(i);
            if (l == line || (coords = GMath.intersect(coordsLine1, coordsLine2, coordsL1 = solid.getPoint((String)l.firstLabel()).coords, coordsL2 = solid.getPoint((String)l.lastLabel()).coords, epsilon)) == null || !GMath.isStrictlyBetween(coords, coordsLine1, coordsLine2, epsilon) || !GMath.isBetween(coords, coordsL1, coordsL2, epsilon)) continue;
            GPoint3d p = solid.getPoint(coords);
            if (p == null) {
                p = solid.addPoint(coords);
            }
            if (!line.contains(p.getLabel())) {
                line.insert(p, solid);
            }
            if (l.contains(p.getLabel())) continue;
            l.insert(p, solid);
        }
        for (i = this.sideCount; i < this.lineCount(); ++i) {
            GPoint3d p;
            l = this.lineAt(i);
            if (l == line) continue;
            coordsL1 = solid.getPoint((String)l.firstLabel()).coords;
            coordsL2 = solid.getPoint((String)l.lastLabel()).coords;
            int indexLine = -1;
            int indexL = -1;
            for (int j = 0; j < l.labelCount(); ++j) {
                indexLine = line.indexOf(l.labelAt(j));
                if (indexLine < 0) continue;
                indexL = j;
                break;
            }
            if (indexL >= 0) {
                Vector3d v = new Vector3d((Tuple3d)coordsL2);
                v.sub((Tuple3d)coordsL1);
                if (v.dot(n) > 0.0) {
                    for (int j = indexL + 1; j < l.labelCount(); ++j) {
                        p = solid.getPoint(l.labelAt(j));
                        toBeRemovedPoints.add(p);
                    }
                    if (indexL <= 0) continue;
                    GLine ll = new GLine(l, 0, indexL);
                    ls.add(ll);
                    continue;
                }
                for (int j = 0; j < indexL; ++j) {
                    p = solid.getPoint(l.labelAt(j));
                    toBeRemovedPoints.add(p);
                }
                if (indexL >= l.labelCount() - 1) continue;
                GLine ll = new GLine(l, indexL, l.labelCount() - 1);
                ls.add(ll);
                continue;
            }
            Vector3d v = new Vector3d((Tuple3d)coordsL1);
            v.sub((Tuple3d)coordsLine1);
            if (v.dot(n) > 0.0) {
                for (int j = 0; j < l.labelCount(); ++j) {
                    p = solid.getPoint(l.labelAt(j));
                    toBeRemovedPoints.add(p);
                }
                continue;
            }
            GLine ll = l.clone();
            ls.add(ll);
        }
        this.lines = ls;
        this.sideCount = sc;
        this.chainSides();
    }

    public void chainSides() {
        int i;
        ArrayList<GLine> ls = new ArrayList<GLine>();
        GLine line = this.lineAt(0);
        GLine nextLine = this.lineAt(1);
        if (!line.lastLabel().equals(nextLine.firstLabel()) && !line.lastLabel().equals(nextLine.lastLabel())) {
            line.reverse();
        }
        ls.add(line);
        for (i = 1; i < this.sideCount; ++i) {
            nextLine = this.lineAt(i);
            if (!nextLine.firstLabel().equals(line.lastLabel())) {
                nextLine.reverse();
            }
            ls.add(nextLine);
            line = nextLine;
        }
        for (i = this.sideCount; i < this.lineCount(); ++i) {
            line = this.lineAt(i);
            ls.add(line);
        }
        this.lines = ls;
    }

    public void reverse() {
        GLine line;
        int i;
        ArrayList<GLine> ls = new ArrayList<GLine>();
        for (i = this.sideCount - 1; i >= 0; --i) {
            line = this.lineAt(i);
            line.reverse();
            ls.add(line);
        }
        for (i = this.sideCount; i < this.lineCount(); ++i) {
            line = this.lineAt(i);
            ls.add(line);
        }
        this.lines = ls;
    }

    public void anchorAt(int index) {
        GLine line;
        int i;
        ArrayList<GLine> ls = new ArrayList<GLine>();
        for (i = 0; i < this.sideCount; ++i) {
            line = this.lineAt((i + index) % this.sideCount);
            ls.add(line);
        }
        for (i = this.sideCount; i < this.lineCount(); ++i) {
            line = this.lineAt(i);
            ls.add(line);
        }
        this.lines = ls;
    }

    public void addExternalPoint(GPoint3d p, GSolid solid) {
        Vector3d n = this.getNormal(solid);
        ArrayList<GLine> front = new ArrayList<GLine>();
        ArrayList<GLine> rear = new ArrayList<GLine>();
        ArrayList<GLine> rim = new ArrayList<GLine>();
        double epsilon = solid.getEpsilon();
        for (GLine line : this.lines) {
            GPoint3d p1 = solid.getPoint(line.firstLabel());
            GPoint3d p2 = solid.getPoint(line.lastLabel());
            if (GMath.areCollinear(new Point3d[]{p.coords, p1.coords, p2.coords}, epsilon)) {
                rim.add(line);
                continue;
            }
            int orientation = GMath.getOrientation(p.coords, p1.coords, p2.coords, n);
            if (orientation == 0) {
                front.add(line);
                continue;
            }
            if (orientation != 1) continue;
            rear.add(line);
        }
        int index = 0;
        for (int i = 1; i < rear.size(); ++i) {
            GLine line = (GLine)rear.get(i - 1);
            GLine l = (GLine)rear.get(i);
            if (line.lastLabel().equals(l.firstLabel())) continue;
            index = i;
            break;
        }
        ArrayList<GLine> ls = new ArrayList<GLine>();
        for (int i = 0; i < rear.size(); ++i) {
            GLine line = (GLine)rear.get((index + i) % rear.size());
            ls.add(line);
        }
        GLine line1 = new GLine(p.getLabel(), ((GLine)ls.get(0)).firstLabel());
        GLine line2 = new GLine(((GLine)ls.get(ls.size() - 1)).lastLabel(), p.getLabel());
        ls.add(0, line1);
        ls.add(line2);
        this.lines = ls;
        this.sideCount = ls.size();
    }

    public void pointRenamed(String oldLabel, String newLabel) {
        for (GLine line : this.lines) {
            line.pointRenamed(oldLabel, newLabel);
        }
    }

    public boolean isSquare(GSolid solid) {
        return this.isRectangle(solid) && this.isRhombus(solid);
    }

    public boolean isRhombus(GSolid solid) {
        if (!this.isParallelogram(solid)) {
            return false;
        }
        Vector3d v1 = this.lineAt(0).toVector(solid);
        Vector3d v2 = this.lineAt(1).toVector(solid);
        return Math.abs(v1.length() - v2.length()) < solid.getEpsilon();
    }

    public boolean isRectangle(GSolid solid) {
        if (!this.isParallelogram(solid)) {
            return false;
        }
        Vector3d v1 = this.lineAt(0).toVector(solid);
        v1.normalize();
        Vector3d v2 = this.lineAt(1).toVector(solid);
        v2.normalize();
        return Math.abs(v1.dot(v2)) < 1.0E-7;
    }

    public boolean isParallelogram(GSolid solid) {
        if (this.lineCount() != 4) {
            return false;
        }
        Vector3d v1 = this.lineAt(0).toVector(solid);
        Vector3d v2 = this.lineAt(2).toVector(solid);
        v2.add((Tuple3d)v1);
        return v2.length() < solid.getEpsilon();
    }

    public boolean isEquilateralTriangle(GSolid solid) {
        if (this.lineCount() != 3) {
            return false;
        }
        Vector3d v1 = this.lineAt(0).toVector(solid);
        Vector3d v2 = this.lineAt(1).toVector(solid);
        Vector3d v3 = this.lineAt(2).toVector(solid);
        double epsilon = solid.getEpsilon();
        return Math.abs(v1.length() - v2.length()) < epsilon && Math.abs(v1.length() - v3.length()) < epsilon;
    }

    public boolean isIsoscellesTriangle(GSolid solid) {
        if (this.lineCount() != 3) {
            return false;
        }
        Vector3d v1 = this.lineAt(0).toVector(solid);
        Vector3d v2 = this.lineAt(1).toVector(solid);
        Vector3d v3 = this.lineAt(2).toVector(solid);
        double epsilon = solid.getEpsilon();
        return Math.abs(v1.length() - v2.length()) < epsilon || Math.abs(v2.length() - v3.length()) < epsilon || Math.abs(v1.length() - v3.length()) < epsilon;
    }

    public boolean isRectangularTriangle(GSolid solid) {
        if (this.lineCount() != 3) {
            return false;
        }
        Vector3d v1 = this.lineAt(0).toVector(solid);
        v1.normalize();
        Vector3d v2 = this.lineAt(1).toVector(solid);
        v2.normalize();
        Vector3d v3 = this.lineAt(2).toVector(solid);
        v3.normalize();
        return Math.abs(v1.dot(v2)) < 1.0E-7 || Math.abs(v2.dot(v3)) < 1.0E-7 || Math.abs(v1.dot(v3)) < 1.0E-7;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < 3; ++i) {
            buf.append(this.labelAt(i));
        }
        buf.append("]");
        return String.valueOf(buf);
    }
}

