/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.geocentral.geometria.action.GRenameVariableAction;
import net.geocentral.geometria.evaluator.GEvaluator;
import net.geocentral.geometria.evaluator.GTokenizer;
import net.geocentral.geometria.evaluator.token.GToken;
import net.geocentral.geometria.evaluator.token.GTokenBounds;
import net.geocentral.geometria.evaluator.token.GVariable;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GRecordable;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCalculation
implements GRecordable {
    private String expression;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GCalculation() {
    }

    public GCalculation(String expression) {
        logger.info((Object)expression);
        this.expression = expression;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        this.expression = node.getElementsByTagName("expression").item(0).getTextContent();
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<calculation>");
        buf.append("\n<expression>");
        buf.append(this.expression);
        buf.append("</expression>");
        buf.append("\n</calculation>");
    }

    public double getValue(Map<String, GNotepadVariable> variables) throws Exception {
        logger.info((Object)(variables + ", " + this.expression));
        GEvaluator evaluator = new GEvaluator(variables.values());
        try {
            return evaluator.evaluate(this.expression);
        }
        catch (Exception exception) {
            logger.error((Object)this.expression);
            throw new Exception(GDictionary.get("BadNotepadRecord", this.expression));
        }
    }

    public void variableRenamed(GRenameVariableAction action) {
        String oldName = action.getOldName();
        String newName = action.getNewName();
        List<GNotepadVariable> variables = action.getVariables();
        this.replaceVariableName(oldName, newName, variables);
    }

    public void renameVariableUndone(GRenameVariableAction action) {
        String oldName = action.getOldName();
        String newName = action.getNewName();
        List<GNotepadVariable> variables = action.getVariables();
        this.replaceVariableName(newName, oldName, variables);
    }

    void replaceVariableName(String fromName, String toName, List<GNotepadVariable> variables) {
        Map<GToken, GTokenBounds> tokens;
        GTokenizer tokenizer = new GTokenizer(variables);
        try {
            tokens = tokenizer.tokenize(this.expression);
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            return;
        }
        ArrayList<GTokenBounds> tokenBoundList = new ArrayList<GTokenBounds>();
        for (GToken token : tokens.keySet()) {
            if (!(token instanceof GVariable) || !((GVariable)token).getName().equals(fromName)) continue;
            GTokenBounds tokenBounds = tokens.get(token);
            tokenBoundList.add(tokenBounds);
            Collections.sort(tokenBoundList);
        }
        for (int i = tokenBoundList.size() - 1; i >= 0; --i) {
            GTokenBounds tokenBounds = (GTokenBounds)tokenBoundList.get(i);
            String head = this.expression.substring(0, tokenBounds.offset);
            String tail = this.expression.substring(tokenBounds.offset + tokenBounds.size);
            this.expression = head + toName + tail;
        }
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression;
    }
}

