/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.io;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import net.geocentral.geometria.io.GExtensionFileFilter;
import net.geocentral.geometria.io.GFileChooser;
import net.geocentral.geometria.io.GFileWriter;
import net.geocentral.geometria.io.GRemoteFileHandler;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;

public class GRemoteFileWriter
extends GRemoteFileHandler
implements GFileWriter {
    private static final String uploaddocumentHandlerPath = "uploadDoc.php";
    private String filePath;
    private Frame ownerFrame;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GRemoteFileWriter(Frame ownerFrame, URL baseUrl, String filePath) {
        super(baseUrl);
        logger.info((Object)(baseUrl + ", " + filePath));
        this.ownerFrame = ownerFrame;
    }

    public void selectFile() {
        logger.info((Object)this.filePath);
        GFileChooser treeNodeChooser = new GFileChooser(this.docTreeElement, this.ownerFrame, this.filePath);
        int option = treeNodeChooser.showOpenDialog(null);
        if (option == 0) {
            this.filePath = treeNodeChooser.getSelectionPath();
        }
    }

    public void write(String str) throws Exception {
        logger.info((Object)str.length());
        URL url = new URL(this.baseUrl.getProtocol(), this.baseUrl.getHost(), this.baseUrl.getPort(), this.baseUrl.getPath() + uploaddocumentHandlerPath + "?filePath=" + this.filePath);
        logger.info((Object)url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        PrintWriter out = new PrintWriter(connection.getOutputStream());
        ((Writer)out).write(str);
        ((Writer)out).close();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = in.readLine();
        logger.info((Object)response);
        if (response.indexOf("OK") < 0) {
            logger.error((Object)response);
            throw new Exception(GDictionary.get("CannotSave", response));
        }
        connection.disconnect();
    }

    public String getSelectedFilePath() {
        return this.filePath;
    }

    public boolean fileExists() {
        return false;
    }

    public boolean approved() {
        return true;
    }

    public GExtensionFileFilter getFileFilter() {
        logger.error((Object)"");
        throw new RuntimeException();
    }
}

