/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.geocentral.geometria.io.GFileTree;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GFileChooser
extends JDialog
implements ActionListener {
    public static final Dimension SIZE = new Dimension(300, 400);
    private GFileTree tree;
    private JButton selectButton;
    private JButton cancelButton;
    private int option = 1;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");
    private static final long serialVersionUID = 1L;

    public GFileChooser(Element docElement, Frame ownerFrame, String filePath) {
        super(ownerFrame, true);
        logger.info((Object)filePath);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(docElement);
        this.make(node);
        DefaultTreeModel model = new DefaultTreeModel(node);
        this.tree = new GFileTree(model);
        this.tree.setShowsRootHandles(true);
        this.tree.addMouseListener(new GFileChooserMouseAdapter());
        if (filePath != null) {
            this.tree.setSelectionPath(filePath);
        }
        this.setTitle(GDictionary.get("UIManager.FileChooser.openDialogTitleText", new String[0]));
        this.layoutComponents();
        this.pack();
    }

    private void make(DefaultMutableTreeNode node) {
        logger.info((Object)"");
        Element element = (Element)node.getUserObject();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 1) continue;
            DefaultMutableTreeNode tNode = new DefaultMutableTreeNode((Element)nodes.item(i));
            node.add(tNode);
            if (!n.getNodeName().equals("dir")) continue;
            this.make(tNode);
        }
    }

    private void layoutComponents() {
        logger.info((Object)"");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JScrollPane sc = new JScrollPane(this.tree);
        sc.setPreferredSize(SIZE);
        this.getContentPane().add(sc);
        this.getContentPane().add(GGraphicsFactory.getInstance().createSmallRigidArea());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(new EmptyBorder(15, 13, 17, 13));
        this.selectButton = GGraphicsFactory.getInstance().createButton(GDictionary.get("Select", new String[0]));
        this.selectButton.addActionListener(this);
        buttonPane.add(this.selectButton);
        buttonPane.add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.cancelButton = GGraphicsFactory.getInstance().createButton(GDictionary.get("Cancel", new String[0]));
        this.cancelButton.addActionListener(this);
        buttonPane.add(this.cancelButton);
        JComponent[] buttons = new JButton[]{this.selectButton, this.cancelButton};
        GGraphicsFactory.getInstance().adjustSize(buttons);
        this.getContentPane().add(GGraphicsFactory.getInstance().createSmallRigidArea());
        this.getContentPane().add(buttonPane);
    }

    public int showOpenDialog(Component parent) {
        this.setVisible(true);
        return this.option;
    }

    public String getSelectionPath() {
        logger.info((Object)"");
        TreePath treePath = this.tree.getSelectionPath();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            if (i > 0) {
                buf.append("/");
            }
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getPathComponent(i);
            Element node = (Element)treeNode.getUserObject();
            buf.append(node.getAttribute("name"));
        }
        logger.info((Object)buf);
        return buf.toString();
    }

    public void actionPerformed(ActionEvent event) {
        logger.info((Object)"");
        if (event.getSource() == this.selectButton) {
            TreePath path = this.tree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Element element = (Element)node.getUserObject();
            if (element.getNodeName().equals("dir")) {
                this.tree.expandPath(path);
            } else {
                this.option = 0;
                this.dispose();
            }
        } else if (event.getSource() == this.cancelButton) {
            this.option = 1;
            this.dispose();
        }
    }

    class GFileChooserMouseAdapter
    extends MouseAdapter {
        GFileChooserMouseAdapter() {
        }

        public void mouseClicked(MouseEvent event) {
            TreePath path;
            DefaultMutableTreeNode node;
            Element element;
            if (event.getClickCount() > 1 && !(element = (Element)(node = (DefaultMutableTreeNode)(path = GFileChooser.this.tree.getSelectionPath()).getLastPathComponent()).getUserObject()).getNodeName().equals("dir")) {
                GFileChooser.this.option = 0;
                GFileChooser.this.dispose();
                return;
            }
            super.mouseClicked(event);
        }
    }
}

