/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.evaluator.operator;

import net.geocentral.geometria.evaluator.token.GBinaryOperator;
import net.geocentral.geometria.evaluator.token.GValueToken;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;

public class GDivide
implements GBinaryOperator {
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public double evaluate(GValueToken token1, GValueToken token2) throws Exception {
        logger.info((Object)(token1 + ", " + token2));
        try {
            return token1.getValue() / token2.getValue();
        }
        catch (ArithmeticException exception) {
            logger.info((Object)"Divide by zero");
            throw new Exception(GDictionary.get("DivideByZeroError", new String[0]));
        }
    }

    public int getPrecedence() {
        return 20;
    }

    public boolean isAssociative() {
        return false;
    }

    public boolean isLeftAssociative() {
        return true;
    }

    public boolean isRightAssociative() {
        return false;
    }

    public String toString() {
        return "/";
    }
}

