/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.geocentral.geometria.evaluator.GTokenizer;
import net.geocentral.geometria.evaluator.token.GBinaryOperator;
import net.geocentral.geometria.evaluator.token.GDecimal;
import net.geocentral.geometria.evaluator.token.GFunction;
import net.geocentral.geometria.evaluator.token.GLeftParanthesis;
import net.geocentral.geometria.evaluator.token.GOperator;
import net.geocentral.geometria.evaluator.token.GRightParanthesis;
import net.geocentral.geometria.evaluator.token.GToken;
import net.geocentral.geometria.evaluator.token.GTokenBounds;
import net.geocentral.geometria.evaluator.token.GUnaryOperator;
import net.geocentral.geometria.evaluator.token.GValueToken;
import net.geocentral.geometria.evaluator.token.GVariable;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEvaluator {
    private Collection<? extends GVariable> variables;
    private List<GToken> postfixTokens;
    private GTokenBounds errorTokenBounds;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public <T extends GVariable> GEvaluator() {
    }

    public <T extends GVariable> GEvaluator(Collection<T> variables) {
        this.variables = variables;
    }

    public double evaluate(String input) throws Exception {
        Map<GToken, GTokenBounds> infixTokenMap;
        logger.info((Object)input);
        GTokenizer tokenizer = new GTokenizer(this.variables);
        try {
            infixTokenMap = tokenizer.tokenize(input);
        }
        catch (Exception exception) {
            this.errorTokenBounds = tokenizer.getErrorTokenBounds();
            throw exception;
        }
        this.postfixTokens = new ArrayList<GToken>();
        this.infixToPostfix(infixTokenMap, this.postfixTokens);
        return this.evaluate(infixTokenMap, this.postfixTokens);
    }

    public GTokenBounds getErrorTokenBounds() {
        return this.errorTokenBounds;
    }

    public List<GToken> getPostfixTokens() {
        return this.postfixTokens;
    }

    private void infixToPostfix(Map<GToken, GTokenBounds> infixTokenMap, List<GToken> postfixTokens) throws Exception {
        logger.info((Object)(infixTokenMap + ", " + postfixTokens));
        Stack<GToken> stack = new Stack<GToken>();
        for (GToken token : infixTokenMap.keySet()) {
            GToken t;
            if (token instanceof GValueToken) {
                postfixTokens.add(token);
                continue;
            }
            if (token instanceof GFunction) {
                stack.push(token);
                continue;
            }
            if (token instanceof GOperator) {
                while (!stack.isEmpty() && (t = (GToken)stack.peek()) instanceof GOperator && ((token instanceof GUnaryOperator || ((GBinaryOperator)token).isRightAssociative()) && ((GOperator)token).getPrecedence() < ((GOperator)t).getPrecedence() || (((GBinaryOperator)token).isLeftAssociative() || ((GBinaryOperator)token).isAssociative()) && ((GOperator)token).getPrecedence() <= ((GOperator)t).getPrecedence())) {
                    stack.pop();
                    postfixTokens.add(t);
                }
                stack.push(token);
                continue;
            }
            if (token instanceof GLeftParanthesis) {
                stack.push(token);
                continue;
            }
            if (!(token instanceof GRightParanthesis)) continue;
            while (true) {
                if (stack.isEmpty()) {
                    this.errorTokenBounds = infixTokenMap.get(token);
                    logger.info((Object)"Unmatched parantheses");
                    throw new Exception(GDictionary.get("UnmatchedParentheses", new String[0]));
                }
                t = (GToken)stack.peek();
                if (!(t instanceof GOperator)) break;
                stack.pop();
                postfixTokens.add(t);
            }
            if (t instanceof GLeftParanthesis) {
                stack.pop();
                if (stack.isEmpty() || !(stack.peek() instanceof GFunction)) continue;
                postfixTokens.add((GToken)stack.pop());
                continue;
            }
            this.errorTokenBounds = infixTokenMap.get(token);
            logger.info((Object)"Unmatched parantheses");
            throw new Exception(GDictionary.get("UnmatchedParentheses", new String[0]));
        }
        while (!stack.isEmpty()) {
            GToken token = (GToken)stack.pop();
            if (token instanceof GOperator) {
                postfixTokens.add(token);
                continue;
            }
            this.errorTokenBounds = infixTokenMap.get(token);
            logger.info((Object)("Misplaced token: " + token));
            throw new Exception(GDictionary.get("MisplacedToken", String.valueOf(token)));
        }
    }

    private double evaluate(Map<GToken, GTokenBounds> tokenMap, List<GToken> postfixTokens) throws Exception {
        logger.info((Object)(tokenMap + ", " + postfixTokens));
        Stack<GValueToken> stack = new Stack<GValueToken>();
        for (GToken token : postfixTokens) {
            GValueToken t;
            if (token instanceof GValueToken) {
                stack.push((GValueToken)token);
                continue;
            }
            if (token instanceof GFunction) {
                if (stack.isEmpty()) {
                    this.errorTokenBounds = tokenMap.get(token);
                    logger.info((Object)("Function has no arguments: " + token));
                    throw new Exception(GDictionary.get("FunctionHasNoArguments", String.valueOf(token)));
                }
                t = (GValueToken)stack.pop();
                double value = ((GFunction)token).evaluate(t);
                stack.push(new GDecimal(value));
                continue;
            }
            if (token instanceof GUnaryOperator) {
                if (stack.isEmpty()) {
                    this.errorTokenBounds = tokenMap.get(token);
                    logger.info((Object)("Operator has no arguments: " + token));
                    throw new Exception(GDictionary.get("OperatorHasNoArguments", String.valueOf(token)));
                }
                t = (GValueToken)stack.pop();
                double value = ((GUnaryOperator)token).evaluate(t);
                stack.push(new GDecimal(value));
                continue;
            }
            if (!(token instanceof GBinaryOperator)) continue;
            if (stack.size() < 2) {
                this.errorTokenBounds = tokenMap.get(token);
                logger.info((Object)("Operator has not enough arguments: " + token));
                throw new Exception(GDictionary.get("OperatorHasNotEnoughArguments", String.valueOf(token)));
            }
            GValueToken t1 = (GValueToken)stack.pop();
            GValueToken t2 = (GValueToken)stack.pop();
            double value = ((GBinaryOperator)token).evaluate(t2, t1);
            stack.push(new GDecimal(value));
        }
        if (stack.isEmpty()) {
            logger.info((Object)"Nothing to evaluate");
            throw new Exception(GDictionary.get("NothingToEvaluate", new String[0]));
        }
        double value = ((GValueToken)stack.pop()).getValue();
        if (!stack.isEmpty()) {
            GToken token = (GToken)stack.peek();
            this.errorTokenBounds = tokenMap.get(token);
            logger.info((Object)("Misplaced token: " + token));
            throw new Exception(GDictionary.get("MisplacedToken", String.valueOf(token)));
        }
        return value;
    }
}

