/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Arrays;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.evaluator.token.GVariable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GMeasurement;
import net.geocentral.geometria.model.GNotepad;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GVolumeDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GVolumeAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String variableName;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            GFigure figure = document.getSelectedFigure();
            this.figureName = figure.getName();
            GSolid solid = figure.getSolid();
            GVolumeDialog dialog = new GVolumeDialog(documentHandler.getOwnerFrame(), this);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            solid.clearSelection();
        }
        document.setSelectedFigure(this.figureName);
        document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.variableName));
        return true;
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getFigure(this.figureName);
        GSolid solid = figure.getSolid();
        if (this.variableName.length() == 0) {
            logger.info((Object)"No variable");
            throw new Exception(GDictionary.get("EnterVariable", new String[0]));
        }
        if (Arrays.asList(GVariable.RESERVED).contains(this.variableName.toLowerCase())) {
            logger.info((Object)("Reserved variable: " + this.variableName));
            throw new Exception(GDictionary.get("ReservedVariable", this.variableName));
        }
        if (!this.variableName.matches("[a-zA-Z\\p{InCyrillic}_][0-9a-zA-Z\\p{InCyrillic}_]*")) {
            logger.info((Object)("Bad variable: " + this.variableName));
            throw new Exception(GDictionary.get("InvalidVariable", this.variableName));
        }
        if (document.getVariable(this.variableName) != null) {
            logger.info((Object)("Duplicate variable: " + this.variableName));
            throw new Exception(GDictionary.get("DuplicateVariable", this.variableName));
        }
        double volume = solid.computeVolume();
        GNotepadVariable variable = new GNotepadVariable(this.variableName, volume);
        GMeasurement expression = GMeasurement.newVolume(this.figureName);
        GNotepadRecord record = new GNotepadRecord(variable, expression);
        GNotepad notepad = document.getNotepad();
        notepad.add(record);
    }

    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        GNotepad notepad = document.getNotepad();
        notepad.removeLastRecord();
        logger.info((Object)(this.figureName + ", " + this.variableName));
    }

    public GLoggable clone() {
        GVolumeAction action = new GVolumeAction();
        action.figureName = this.figureName;
        action.variableName = this.variableName;
        return action;
    }

    public String toLogString() {
        return GDictionary.get("MeasureVolumeOfFigure", this.variableName, this.figureName);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("variableName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No variable name");
            throw new Exception();
        }
        this.variableName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<variableName>").append(this.variableName).append("</variableName>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String variableName) {
        logger.info((Object)variableName);
        this.variableName = variableName;
    }

    public String getShortDescription() {
        return GDictionary.get("measureVolume", this.figureName);
    }

    public String getFigureName() {
        return this.figureName;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

