/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.model.answer.GConditionAnswer;
import net.geocentral.geometria.model.answer.GFixedPlaneAnswer;
import net.geocentral.geometria.model.answer.GNumberAnswer;
import net.geocentral.geometria.model.answer.GPointSetAnswer;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GSolutionConditionAnswerDialog;
import net.geocentral.geometria.view.GSolutionFixedPlaneAnswerDialog;
import net.geocentral.geometria.view.GSolutionNumberAnswerDialog;
import net.geocentral.geometria.view.GSolutionPointSetAnswerDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GSolutionAnswerAction
implements GLoggable,
GActionWithHelp,
GFigureAction {
    private String valueString;
    private String figureName;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GSolution document = documentHandler.getMasterSolution();
        GProblem problem = document.getProblem();
        GAnswer problemAnswer = problem.getAnswer();
        if (silent) {
            return problemAnswer.validate(this.valueString, this.figureName, document);
        }
        if (problemAnswer instanceof GNumberAnswer) {
            GSolutionNumberAnswerDialog dialog = new GSolutionNumberAnswerDialog(documentHandler.getOwnerFrame(), document, this, (GNumberAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        } else if (problemAnswer instanceof GPointSetAnswer) {
            GSolutionPointSetAnswerDialog dialog = new GSolutionPointSetAnswerDialog(documentHandler.getOwnerFrame(), document, this, (GPointSetAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        } else if (problemAnswer instanceof GFixedPlaneAnswer) {
            GSolutionFixedPlaneAnswerDialog dialog = new GSolutionFixedPlaneAnswerDialog(documentHandler.getOwnerFrame(), document, this, (GFixedPlaneAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        } else if (problemAnswer instanceof GConditionAnswer) {
            GSolutionConditionAnswerDialog dialog = new GSolutionConditionAnswerDialog(documentHandler.getOwnerFrame(), document, this, (GConditionAnswer)problemAnswer);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        }
        documentHandler.setDocumentModified(true);
        logger.info((Object)this.valueString);
        return true;
    }

    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)(this.valueString + " : " + this.figureName));
    }

    public GLoggable clone() {
        GSolutionAnswerAction action = new GSolutionAnswerAction();
        action.valueString = this.valueString;
        action.figureName = this.figureName;
        return action;
    }

    public String toLogString() {
        return GDictionary.get("CorrectAnswer", this.valueString);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("value");
        if (ns.getLength() == 0) {
            logger.info((Object)"No value");
            throw new Exception();
        }
        this.valueString = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("figureName");
        if (ns.getLength() > 0) {
            this.figureName = ns.item(0).getTextContent();
        }
        if ((ns = node.getElementsByTagName("comments")).getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<value>").append(this.valueString).append("</value>");
        if (this.figureName != null) {
            buf.append("\n<figureName>").append(this.figureName).append("</figureName>");
        }
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String valueString, String figureName) {
        logger.info((Object)(valueString + " : " + figureName));
        this.valueString = valueString;
        this.figureName = figureName;
    }

    public String getShortDescription() {
        return GDictionary.get("correctAnswer", new String[0]);
    }

    public String getFigureName() {
        return this.figureName;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

