/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GScaleDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GScaleAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String factorString;
    private String p1Label;
    private String p2Label;
    private GDocument document;
    private GFigure figure;
    private GSolid solid;
    private double factor;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        this.document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            GSolid solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            GScaleDialog dialog = new GScaleDialog(documentHandler.getOwnerFrame(), this);
            dialog.prefill(this.p1Label, this.p2Label);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            solid.clearSelection();
        }
        this.document.getNotepad().update();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.factorString + ", " + this.p1Label + ", " + this.p2Label));
        return true;
    }

    private void prefill(Set<GSelectable> selection) {
        logger.info(selection);
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 1) {
            GSelectable element = it.next();
            if (element instanceof GStick) {
                this.p1Label = ((GStick)element).label1;
                this.p2Label = ((GStick)element).label2;
            }
        } else if (selection.size() == 2) {
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GPoint3d) {
                this.p1Label = ((GPoint3d)element1).getLabel();
                this.p2Label = ((GPoint3d)element2).getLabel();
            }
        }
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        if (this.factorString.length() == 0) {
            logger.info((Object)"No factor");
            throw new Exception(GDictionary.get("EnterValidExpressionForScalingFactor", new String[0]));
        }
        GNotepadVariable variable = this.document.getVariable(this.factorString);
        if (variable != null) {
            this.factor = variable.getValue();
        } else {
            List<GNotepadVariable> variables = this.document.getNotepad().getVariables();
            Double f = GMath.evaluate(this.factorString, variables);
            if (f == null) {
                logger.info((Object)("Bad factor: " + this.factorString));
                throw new Exception(GDictionary.get("EnterValidExpressionForScalingFactor", new String[0]));
            }
            this.factor = f;
        }
        if (this.factor <= 0.0) {
            logger.info((Object)("Factor must be positive: " + this.factor));
            throw new Exception(GDictionary.get("ScalingFactorMustBePositive", new String[0]));
        }
        if (this.p1Label.length() == 0 || this.p2Label.length() == 0) {
            logger.info((Object)("No end points: " + this.p1Label + ", " + this.p2Label));
            throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
        }
        GPoint3d p1 = this.solid.getPoint(this.p1Label);
        GPoint3d p2 = this.solid.getPoint(this.p2Label);
        if (p1 == null) {
            logger.info((Object)("No point: " + this.p1Label));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.p1Label));
        }
        if (p2 == null) {
            logger.info((Object)("No point: " + this.p2Label));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.p2Label));
        }
        if (p1 == p2) {
            logger.info((Object)("Equal points: " + p1 + ", " + p2));
            throw new Exception(GDictionary.get("Ref2DistinctPoints", new String[0]));
        }
        Vector3d v = new Vector3d((Tuple3d)p2.coords);
        v.sub((Tuple3d)p1.coords);
        this.solid.scale(new Point3d(0.0, 0.0, 0.0), v, this.factor);
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GPoint3d p1 = this.solid.getPoint(this.p1Label);
        GPoint3d p2 = this.solid.getPoint(this.p2Label);
        Vector3d v = new Vector3d((Tuple3d)p2.coords);
        v.sub((Tuple3d)p1.coords);
        this.solid.scale(new Point3d(0.0, 0.0, 0.0), v, 1.0 / this.factor);
        this.document.getNotepad().update();
        this.document.setSelectedFigure(this.figureName);
        this.figure.repaint();
        logger.info((Object)(this.figureName + ", " + this.factorString + ", " + this.p1Label + ", " + this.p2Label));
    }

    @Override
    public GLoggable clone() {
        GScaleAction action = new GScaleAction();
        action.figureName = this.figureName;
        action.factorString = this.factorString;
        action.p1Label = this.p1Label;
        action.p2Label = this.p2Label;
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("ScaleFigureByFactor", this.figureName, this.factorString, this.p1Label + this.p2Label);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("factor");
        if (ns.getLength() == 0) {
            logger.error((Object)"No factor");
            throw new Exception();
        }
        this.factorString = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.p1Label = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.p2Label = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<factor>").append(this.factorString).append("</factor>").append("\n<p1Label>").append(this.p1Label).append("</p1Label>").append("\n<p2Label>").append(this.p2Label).append("</p2Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p1String, String p2String, String factorString) {
        logger.info((Object)(p1String + ", " + p2String + ", " + factorString));
        this.p1Label = p1String.toUpperCase();
        this.p2Label = p2String.toUpperCase();
        this.factorString = factorString;
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("scaleFigureByFactor", this.figureName, this.factorString);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

