/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.awt.Frame;
import javax.swing.filechooser.FileFilter;
import net.geocentral.geometria.action.GAction;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.io.GFileWriter;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import org.apache.log4j.Logger;

public class GSaveFigureAction
implements GAction {
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        String filePath = documentHandler.getFigurePath();
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getSelectedFigure();
        GSolid solid = figure.getSolid();
        Frame ownerFrame = documentHandler.getOwnerFrame();
        FileFilter[] fileFilters = new FileFilter[]{};
        GFileWriter writer = documentHandler.getFileWriter(ownerFrame, filePath, fileFilters, true);
        try {
            int option;
            writer.selectFile();
            if (!writer.approved()) {
                return false;
            }
            if (writer.fileExists() && (option = GGraphicsFactory.getInstance().showYesNoDialog(GDictionary.get("FileExistsOverwrite", new String[0]))) != 0) {
                return false;
            }
            StringBuffer buf = new StringBuffer();
            solid.serialize(buf, true);
            writer.write(String.valueOf(buf));
        }
        catch (Exception exception) {
            documentHandler.error(exception);
            return false;
        }
        filePath = writer.getSelectedFilePath();
        logger.info((Object)(filePath + ", " + figure.getName()));
        return true;
    }
}

