/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Set;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GUndoable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.view.GRenamePointDialog;
import org.apache.log4j.Logger;

public class GRenamePointAction
implements GUndoable,
GFigureAction,
GActionWithHelp {
    private String oldLabel;
    private String newLabel;
    private String figureName;
    private GDocument document;
    private GFigure figure;
    private GSolid solid;
    private String helpId;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        this.document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            this.figure = this.document.getSelectedFigure();
            this.figureName = this.figure.getName();
            this.solid = this.figure.getSolid();
            this.prefillSelection();
            GRenamePointDialog dialog = new GRenamePointDialog(documentHandler.getOwnerFrame(), this);
            dialog.prefill(this.oldLabel);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            this.solid.clearSelection();
        }
        this.document.getNotepad().pointRenamed(this);
        documentHandler.notepadChanged();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.oldLabel + ", " + this.newLabel));
        return true;
    }

    private void prefillSelection() {
        Set<GSelectable> selection = this.solid.getSelection();
        for (GSelectable element : selection) {
            if (!(element instanceof GPoint3d)) continue;
            this.oldLabel = ((GPoint3d)element).getLabel();
            break;
        }
    }

    public void setInput(String oldLabel, String newLabel) {
        this.oldLabel = oldLabel;
        this.newLabel = newLabel;
    }

    public void validateApply() throws Exception {
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        if (this.oldLabel.trim().length() == 0 || this.newLabel.trim().length() == 0) {
            logger.error((Object)"No label");
            throw new Exception(GDictionary.get("EnterLabels", new String[0]));
        }
        if (this.solid.getPoint(this.oldLabel) == null) {
            logger.error((Object)("No such point " + this.oldLabel));
            throw new Exception(GDictionary.get("NoSuchPoint", this.oldLabel));
        }
        if (this.oldLabel.equals(this.newLabel)) {
            logger.error((Object)(this.oldLabel + ", " + this.newLabel));
            throw new Exception(GDictionary.get("LabelsAreSame", new String[0]));
        }
        if (!this.newLabel.matches("[A-Z][0-9]*")) {
            logger.error((Object)("Bad label " + this.newLabel));
            throw new Exception(GDictionary.get("BadLabel", this.newLabel));
        }
        if (this.solid.getPoint(this.newLabel) != null) {
            logger.error((Object)("Duplicate label " + this.newLabel));
            throw new Exception(GDictionary.get("DuplicateLabel", this.newLabel));
        }
        this.solid.RenamePoint(this.oldLabel, this.newLabel);
        this.solid.makeConfig();
    }

    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.RenamePoint(this.newLabel, this.oldLabel);
        this.solid.makeConfig();
        this.document.getNotepad().renamePointUndone(this);
        documentHandler.notepadChanged();
        this.figure.repaint();
        this.document.setSelectedFigure(this.figureName);
        logger.info((Object)(this.figureName + ", " + this.newLabel + ", " + this.oldLabel));
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>");
        buf.append("\n<className>");
        buf.append(this.getClass().getSimpleName());
        buf.append("</className>");
        buf.append("\n<oldLabelName>");
        buf.append(this.oldLabel);
        buf.append("</oldLabel>");
        buf.append("\n<newLabel>");
        buf.append(this.newLabel);
        buf.append("</newLabel>");
        buf.append("\n<figureName>");
        buf.append(this.figureName);
        buf.append("</figureName>");
        buf.append("\n</action>");
    }

    public String getShortDescription() {
        return GDictionary.get("renamePoint", this.oldLabel, this.newLabel, this.figureName);
    }

    public String getFigureName() {
        return this.figureName;
    }

    public String getOldLabel() {
        return this.oldLabel;
    }

    public String getNewLabel() {
        return this.newLabel;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

