/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.model.answer.GConditionAnswer;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GRenameFigureAction
implements GLoggable,
GFigureAction {
    public static final String FIGURE_NAME_PATTERN = "[^\\>\\<\\&\\%\\s]+";
    private String oldFigureName;
    private String newFigureName;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        GAnswer answer;
        GFigure figure;
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        if (silent) {
            figure = document.getFigure(this.oldFigureName);
        } else {
            figure = document.getSelectedFigure();
            this.oldFigureName = figure.getName();
            this.newFigureName = GGraphicsFactory.getInstance().showInputDialog(GDictionary.get("RenameFigureInput", this.oldFigureName));
            if (this.newFigureName == null) {
                return false;
            }
            this.newFigureName = this.newFigureName.trim();
            if (this.newFigureName.length() == 0) {
                return false;
            }
            if (!this.newFigureName.matches(FIGURE_NAME_PATTERN)) {
                logger.error((Object)this.newFigureName);
                GGraphicsFactory.getInstance().showErrorDialog(GDictionary.get("BadFigureName", this.newFigureName));
                return false;
            }
            if (document.getFigure(this.newFigureName) != null) {
                logger.error((Object)this.newFigureName);
                GGraphicsFactory.getInstance().showErrorDialog(GDictionary.get("DuplicateFigureName", this.newFigureName));
                return false;
            }
        }
        document.renameFigure(figure, this.newFigureName);
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        document.setSelectedFigure(this.newFigureName);
        documentHandler.renameFigure(this.oldFigureName, this.newFigureName);
        document.getNotepad().figureRenamed(this);
        documentHandler.notepadChanged();
        if (document instanceof GProblem && (answer = ((GProblem)document).getAnswer()) instanceof GConditionAnswer) {
            ((GConditionAnswer)answer).figureRenamed(this);
        }
        logger.info((Object)(this.oldFigureName + ", " + this.newFigureName));
        return true;
    }

    public void undo(GDocumentHandler documentHandler) {
        GAnswer answer;
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getFigure(this.newFigureName);
        document.renameFigure(figure, this.oldFigureName);
        document.setSelectedFigure(this.oldFigureName);
        documentHandler.renameFigure(this.newFigureName, this.oldFigureName);
        document.getNotepad().renameFigureUndone(this);
        documentHandler.notepadChanged();
        if (document instanceof GProblem && (answer = ((GProblem)document).getAnswer()) instanceof GConditionAnswer) {
            ((GConditionAnswer)answer).renameFigureUndone(this);
        }
        logger.info((Object)(this.oldFigureName + ", " + this.newFigureName));
    }

    public GLoggable clone() {
        GRenameFigureAction action = new GRenameFigureAction();
        action.oldFigureName = this.oldFigureName;
        action.newFigureName = this.newFigureName;
        return action;
    }

    public String toLogString() {
        return GDictionary.get("RenameFigure", this.oldFigureName, this.newFigureName);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("oldFigureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No old figure name");
            throw new Exception();
        }
        this.oldFigureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("newFigureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No new figure name");
            throw new Exception();
        }
        this.newFigureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<oldFigureName>").append(this.oldFigureName).append("</oldFigureName>").append("\n<newFigureName>").append(this.newFigureName).append("</newFigureName>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public String getShortDescription() {
        return GDictionary.get("renameFigure", this.oldFigureName, this.newFigureName);
    }

    public String getFigureName() {
        return this.newFigureName;
    }

    public String getOldFigureName() {
        return this.oldFigureName;
    }

    public String getNewFigureName() {
        return this.newFigureName;
    }
}

