/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.model.answer.GConditionAnswer;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GRemoveFigureAction
implements GLoggable {
    private String figureName;
    private GFigure figure;
    private int figureIndex;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        GAnswer answer;
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        if (silent) {
            this.figure = document.getFigure(this.figureName);
        } else {
            this.figure = document.getSelectedFigure();
            this.figureName = this.figure.getName();
        }
        if (document instanceof GProblem && (answer = ((GProblem)document).getAnswer()) instanceof GConditionAnswer && ((GConditionAnswer)answer).isFigureReferenced(this.figureName)) {
            logger.info((Object)this.figureName);
            documentHandler.error(GDictionary.get("CannotRemoveFigureRefInAnswer", this.figureName));
            return false;
        }
        this.figureIndex = document.removeFigure(this.figureName);
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        documentHandler.removeFigure(this.figureName);
        document.getNotepad().figureRemoved(this);
        documentHandler.documentChanged();
        logger.info((Object)this.figureName);
        return true;
    }

    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        document.addFigure(this.figure, this.figureIndex);
        document.setSelectedFigure(this.figureName);
        documentHandler.addFigure(this.figure, this.figureIndex);
        document.getNotepad().removeFigureUndone(this);
        documentHandler.notepadChanged();
        logger.info((Object)this.figureName);
    }

    public GLoggable clone() {
        GRemoveFigureAction action = new GRemoveFigureAction();
        action.figureName = this.figureName;
        return action;
    }

    public String toLogString() {
        return GDictionary.get("RemoveFigure", this.figureName);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public String getShortDescription() {
        return GDictionary.get("removeFigure", this.figureName);
    }

    public String getFigureName() {
        return this.figureName;
    }
}

