/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.io.InputStream;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GXmlUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GPlatonicAction
implements GLoggable {
    private String type;
    private String figureName;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GPlatonicAction() {
    }

    public GPlatonicAction(String parameter) {
        this.type = parameter;
    }

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GSolid solid = new GSolid();
        try {
            InputStream in = this.getClass().getResourceAsStream("/gallery/" + this.type);
            Element docElement = GXmlUtils.read(in);
            in.close();
            solid = new GSolid();
            solid.make(docElement);
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            return false;
        }
        GFigure figure = documentHandler.newFigure(solid);
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        documentHandler.notepadChanged();
        this.figureName = figure.getName();
        logger.info((Object)this.figureName);
        return true;
    }

    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        document.removeFigure(this.figureName);
        documentHandler.removeFigure(this.figureName);
        documentHandler.notepadChanged();
        logger.info((Object)this.figureName);
    }

    public GLoggable clone() {
        GPlatonicAction action = new GPlatonicAction();
        action.figureName = this.figureName;
        action.type = this.type;
        return action;
    }

    public String toLogString() {
        StringBuffer buf = new StringBuffer();
        buf.append(GDictionary.get("Create", this.type, this.figureName));
        return String.valueOf(buf);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("type");
        if (ns.getLength() == 0) {
            logger.error((Object)"No type");
            throw new Exception();
        }
        this.type = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<type>").append(this.type).append("</type>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public String getShortDescription() {
        return GDictionary.get("create", this.type, this.figureName);
    }
}

