/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GUndefinedItemException;
import net.geocentral.geometria.view.GPerpendicularDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPerpendicularAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String[] pLabels;
    private String[] fLabels;
    private GDocument document;
    private GFigure figure;
    private GSolid solid;
    private GFace face;
    private List<GPoint3d> addedPoints;
    private GLine addedLine;
    private List<GLine> removedLines;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        GSolid solid;
        GDocumentHandler documentHandler;
        block6: {
            logger.info((Object)silent);
            documentHandler = GDocumentHandler.getInstance();
            this.document = documentHandler.getActiveDocument();
            if (silent) {
                try {
                    this.validateApply();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                GPerpendicularDialog dialog = new GPerpendicularDialog(documentHandler.getOwnerFrame(), this);
                dialog.prefill(this.pLabels[0], this.pLabels[1], this.pLabels[2]);
                dialog.setVisible(true);
                if (dialog.getResult()) break block6;
                return false;
            }
        }
        solid.clearSelection();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + Arrays.asList(this.pLabels)));
        return true;
    }

    private void prefill(Set<GSelectable> selection) {
        logger.info(selection);
        this.pLabels = new String[3];
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 2) {
            GStick s;
            GPoint3d p;
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GStick) {
                p = (GPoint3d)element1;
                s = (GStick)element2;
            } else if (element1 instanceof GStick && element2 instanceof GPoint3d) {
                p = (GPoint3d)element2;
                s = (GStick)element1;
            } else {
                return;
            }
            this.pLabels[0] = p.getLabel();
            this.pLabels[1] = s.label1;
            this.pLabels[2] = s.label2;
        }
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        double epsilon = this.solid.getEpsilon();
        GPoint3d[] ps = new GPoint3d[3];
        for (int i = 0; i < 3; ++i) {
            if (this.pLabels[i].length() == 0) {
                logger.info((Object)("No end points: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
            }
            ps[i] = this.solid.getPoint(this.pLabels[i]);
            if (ps[i] != null) continue;
            logger.info((Object)("No point: " + this.pLabels[i]));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.pLabels[i]));
        }
        if (ps[1] == ps[2]) {
            logger.info((Object)("Equal end points: " + ps[1] + ", " + ps[2]));
            throw new Exception(GDictionary.get("EndPointsCannotBeEqual", new String[0]));
        }
        Collection<GFace> faces = this.solid.facesThroughPoints(this.pLabels);
        if (faces.isEmpty()) {
            logger.info((Object)("Not in the same face: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("PointLineDoNotBelongToSameFace", this.pLabels[0], this.pLabels[1] + this.pLabels[2], this.figureName));
        }
        Iterator<GFace> it = faces.iterator();
        if (faces.size() > 1) {
            if (this.fLabels == null) {
                String[] fLabelStrings = new String[2];
                for (int i = 0; i < 2; ++i) {
                    GFace face = it.next();
                    StringBuffer buf = new StringBuffer();
                    buf.append(face.labelAt(0)).append(face.labelAt(1)).append(face.labelAt(2));
                    fLabelStrings[i] = String.valueOf(buf);
                }
                throw new GUndefinedItemException(fLabelStrings);
            }
            this.face = this.solid.facesThroughPoints(this.fLabels).iterator().next();
        } else {
            this.face = it.next();
        }
        GLine line1 = this.face.lineThroughPoints(this.pLabels[1], this.pLabels[2]);
        if (line1 == null) {
            logger.info((Object)("No line: " + this.pLabels[1] + ", " + this.pLabels[2]));
            throw new Exception(GDictionary.get("NoLinePassesThroughPoints", this.pLabels[1], this.pLabels[2], this.figureName));
        }
        if (line1.contains(this.pLabels[0])) {
            GPoint3d p;
            Vector3d v = new Vector3d((Tuple3d)ps[2].coords);
            v.sub((Tuple3d)ps[1].coords);
            List<Point3d> iPoints = this.face.intersectPlane(ps[0].coords, v, this.solid);
            if (iPoints.size() < 2) {
                logger.info((Object)("Outside figure: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("PerpendicularIsOutsideFigure", this.pLabels[0], this.pLabels[1] + this.pLabels[2], this.figureName));
            }
            GPoint3d p1 = this.solid.getPoint(iPoints.get(0));
            GPoint3d p2 = this.solid.getPoint(iPoints.get(1));
            if (p1 != null && p2 != null && this.face.lineThroughPoints(p1.getLabel(), p2.getLabel()) != null) {
                logger.info((Object)("Already drawn: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("PerpendicularAlreadyDrawn", this.pLabels[0], this.pLabels[1] + this.pLabels[2], this.figureName));
            }
            this.addedPoints = new ArrayList<GPoint3d>();
            if (p1 == null) {
                p = this.solid.addPoint(iPoints.get(0));
                this.addedPoints.add(p);
                p1 = p;
            }
            if (p2 == null) {
                p = this.solid.addPoint(iPoints.get(1));
                this.addedPoints.add(p);
                p2 = p;
            }
            block2: for (GPoint3d p3 : this.addedPoints) {
                for (int i = 0; i < this.face.sideCount(); ++i) {
                    GLine line = this.face.lineAt(i);
                    GPoint3d pp1 = this.solid.getPoint(line.firstLabel());
                    GPoint3d pp2 = this.solid.getPoint(line.lastLabel());
                    if (!GMath.isBetween(p3.coords, pp1.coords, pp2.coords, epsilon)) continue;
                    GFace f = line.getFace();
                    f.addPoint(p3, this.solid);
                    f = line.getTwin().getFace();
                    f.addPoint(p3, this.solid);
                    continue block2;
                }
            }
            this.removedLines = new ArrayList<GLine>();
            this.addedLine = this.face.addLine(p1, p2, this.removedLines, this.solid);
        } else {
            Collection<GLine> lines;
            Point3d pr0 = GMath.project(ps[0].coords, ps[1].coords, ps[2].coords);
            GPoint3d p = this.solid.getPoint(pr0);
            Vector3d v = new Vector3d((Tuple3d)pr0);
            v.sub((Tuple3d)ps[0].coords);
            Object[] result = this.face.intersectRay(ps[0].coords, v, this.solid);
            if (result == null) {
                logger.info((Object)("Outside figure: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("PerpendicularIsOutsideFigure", this.pLabels[0], this.pLabels[1] + this.pLabels[2], this.figureName));
            }
            Point3d pCoords = (Point3d)result[1];
            p = this.solid.getPoint(pCoords);
            if (p != null && !(lines = this.solid.linesThroughPoints(p.getLabel(), this.pLabels[0])).isEmpty()) {
                logger.info((Object)("Already drawn: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("PerpendicularAlreadyDrawn", this.pLabels[0], this.pLabels[1] + this.pLabels[2], this.figureName));
            }
            GLine line = (GLine)result[0];
            if (p == null) {
                p = this.solid.addPoint(pCoords);
                GFace f = line.getFace();
                f.addPoint(p, this.solid);
                f = line.getTwin().getFace();
                f.addPoint(p, this.solid);
                this.addedPoints = new ArrayList<GPoint3d>();
                this.addedPoints.add(p);
            }
            this.removedLines = new ArrayList<GLine>();
            this.addedLine = this.face.addLine(ps[0], p, this.removedLines, this.solid);
        }
        this.solid.makeConfig();
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        for (GPoint3d p : this.addedPoints) {
            Collection<GFace> faces = this.solid.facesThroughPoint(p.getLabel());
            for (GFace face : faces) {
                face.removePoint(p);
            }
            this.solid.removePoint(p.getLabel());
        }
        this.face.undoAddLine(this.addedLine, this.removedLines);
        this.solid.makeConfig();
        this.figure.repaint();
        this.document.setSelectedFigure(this.figureName);
        logger.info((Object)("Perpendicular through " + this.pLabels[0] + " to " + this.pLabels[1] + this.pLabels[2] + " in figure " + this.figureName + " undone"));
        logger.info((Object)(this.figureName + ", " + Arrays.asList(this.pLabels)));
    }

    @Override
    public GLoggable clone() {
        int i;
        GPerpendicularAction action = new GPerpendicularAction();
        action.figureName = this.figureName;
        if (this.fLabels != null) {
            action.fLabels = this.fLabels;
            for (i = 0; i < 3; ++i) {
                action.fLabels[i] = this.fLabels[i];
            }
        }
        action.pLabels = new String[3];
        for (i = 0; i < 3; ++i) {
            action.pLabels[i] = this.pLabels[i];
        }
        return action;
    }

    @Override
    public String toLogString() {
        if (this.fLabels != null) {
            String s = this.fLabels[0] + this.fLabels[1] + this.fLabels[2];
            return GDictionary.get("DrawPerpendicularInFace", this.pLabels[0], this.pLabels[1] + this.pLabels[2], s, this.figureName);
        }
        return GDictionary.get("DrawPerpendicularInFigure", this.pLabels[0], this.pLabels[1] + this.pLabels[2], this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("fLabel1");
        if (ns.getLength() > 0) {
            this.fLabels = new String[3];
            this.fLabels[0] = ns.item(0).getTextContent();
            ns = node.getElementsByTagName("fLabel2");
            if (ns.getLength() == 0) {
                logger.error((Object)"No fLabel2");
                throw new Exception();
            }
            this.fLabels[1] = ns.item(0).getTextContent();
            ns = node.getElementsByTagName("fLabel3");
            if (ns.getLength() == 0) {
                logger.error((Object)"No fLabel3");
                throw new Exception();
            }
            this.fLabels[2] = ns.item(0).getTextContent();
        }
        this.pLabels = new String[3];
        ns = node.getElementsByTagName("p0Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p0Label");
            throw new Exception();
        }
        this.pLabels[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.pLabels[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.pLabels[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>");
        if (this.fLabels != null) {
            buf.append("\n<fLabel1>").append(this.fLabels[0]).append("</fLabel1>").append("\n<fLabel2>").append(this.fLabels[1]).append("</fLabel2>").append("\n<fLabel3>").append(this.fLabels[2]).append("</fLabel3>");
        }
        buf.append("\n<p0Label>").append(this.pLabels[0]).append("</p0Label>").append("\n<p1Label>").append(this.pLabels[1]).append("</p1Label>").append("\n<p2Label>").append(this.pLabels[2]).append("</p2Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p0String, String p1String, String p2String, String fLabelsString) {
        logger.info((Object)(p0String + ", " + p1String + ", " + p2String + ", " + fLabelsString));
        this.pLabels[0] = p0String.toUpperCase();
        this.pLabels[1] = p1String.toUpperCase();
        this.pLabels[2] = p2String.toUpperCase();
        if (fLabelsString != null) {
            this.fLabels = new String[3];
            StringBuffer buf = new StringBuffer();
            buf.append("(").append("[A-Z][0-9]*").append(")").append("(").append("[A-Z][0-9]*").append(")").append("(").append("[A-Z][0-9]*").append(")");
            Pattern pattern = Pattern.compile(String.valueOf(buf));
            Matcher matcher = pattern.matcher(fLabelsString);
            matcher.matches();
            for (int i = 0; i < 3; ++i) {
                this.fLabels[i] = matcher.group(i + 1);
            }
        }
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("drawPerpendicular", this.pLabels[0], this.pLabels[1] + this.pLabels[2]);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

