/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.awt.Frame;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.geocentral.geometria.action.GAction;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.io.GFileReader;
import net.geocentral.geometria.model.GLog;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GXmlUtils;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class GOpenSolutionAction
implements GAction {
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        GSolution document;
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        if (!documentHandler.onCloseDocument()) {
            return false;
        }
        String filePath = documentHandler.getSolutionPath();
        Frame ownerFrame = documentHandler.getOwnerFrame();
        FileFilter[] filters = new FileFilter[]{};
        GFileReader reader = documentHandler.getFileReader(ownerFrame, filePath, filters, true);
        try {
            reader.init();
            reader.selectFile();
            filePath = reader.getSelectedFilePath();
            if (filePath == null) {
                return false;
            }
            InputSource source = new InputSource(reader.getInputStream());
            document = GXmlUtils.readSolution(source);
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            documentHandler.error(exception);
            return false;
        }
        if (this.execute(document)) {
            this.setFilePath(filePath);
            return true;
        }
        return false;
    }

    public boolean execute(GSolution document) {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        try {
            document.getNotepad().validate();
        }
        catch (Exception exception) {
            documentHandler.error(exception.getMessage());
            return false;
        }
        documentHandler.setActiveDocument(document);
        documentHandler.setMasterSolution(document);
        document.importFigures(document.getProblem());
        documentHandler.clearUndoableActions();
        GLog log = document.getLog();
        for (int i = 0; i < log.size(); ++i) {
            GLoggable action = log.actionAt(i);
            if (action.execute(true)) continue;
            logger.error((Object)("Bad log entry " + action));
            documentHandler.setActiveDocument(null);
            documentHandler.setMasterSolution(null);
            documentHandler.documentChanged();
            documentHandler.updateActionHandlerStates();
            documentHandler.error(GDictionary.get("FileCorruptedSeeLog", new String[0]));
            return false;
        }
        documentHandler.documentChanged();
        documentHandler.setDocumentModified(false);
        return true;
    }

    public void setFilePath(String filePath) {
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        documentHandler.setSolutionPath(filePath);
        String fileName = new File(filePath).getName();
        documentHandler.setTitle(fileName);
        logger.info((Object)filePath);
    }
}

