/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GUndefinedItemException;
import net.geocentral.geometria.view.GLayAngleDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLayAngleAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String angleString;
    private String pLabel1;
    private String pLabel2;
    private String[] fLabels;
    private GDocument document;
    private GFigure figure;
    private GSolid solid;
    private GFace face;
    private List<GPoint3d> addedPoints;
    private List<GLine> addedLines;
    private List<GLine> removedLines;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        GSolid solid;
        GDocumentHandler documentHandler;
        block7: {
            logger.info((Object)silent);
            documentHandler = GDocumentHandler.getInstance();
            this.document = documentHandler.getActiveDocument();
            if (silent) {
                try {
                    this.validateApply();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            GNotepadRecord record = this.document.getNotepad().getSelectedRecord();
            if (record != null) {
                this.angleString = record.getVariable().getName();
            }
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                GLayAngleDialog dialog = new GLayAngleDialog(documentHandler.getOwnerFrame(), this);
                dialog.prefill(this.pLabel1, this.pLabel2, this.angleString);
                dialog.setVisible(true);
                if (dialog.getResult()) break block7;
                return false;
            }
        }
        solid.clearSelection();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.angleString + ", " + this.pLabel1 + ", " + this.pLabel2));
        return true;
    }

    private void prefill(Set<GSelectable> selection) {
        logger.info(selection);
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 2) {
            GStick s;
            String label;
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GStick) {
                label = ((GPoint3d)element1).getLabel();
                s = (GStick)element2;
            } else if (element1 instanceof GStick && element2 instanceof GPoint3d) {
                label = ((GPoint3d)element2).getLabel();
                s = (GStick)element1;
            } else {
                return;
            }
            if (label.equals(s.label1)) {
                this.pLabel1 = label;
                this.pLabel2 = s.label2;
            } else if (label.equals(s.label2)) {
                this.pLabel1 = label;
                this.pLabel2 = s.label1;
            }
        }
    }

    public void validateApply() throws Exception {
        Double angle;
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        if (this.angleString.length() == 0) {
            logger.info((Object)"No angle");
            throw new Exception(GDictionary.get("EnterValidExpressionForAngle", new String[0]));
        }
        GNotepadVariable variable = this.document.getVariable(this.angleString);
        if (variable != null) {
            angle = variable.getValue();
        } else {
            List<GNotepadVariable> variables = this.document.getNotepad().getVariables();
            angle = GMath.evaluate(this.angleString, variables);
            if (angle == null) {
                logger.info((Object)("Bad expression: " + this.angleString));
                throw new Exception(GDictionary.get("EnterValidExpressionForAngle", new String[0]));
            }
        }
        if (angle <= 0.0 || angle >= Math.PI) {
            logger.info((Object)("Angle must be between 0 and pi: " + angle));
            throw new Exception(GDictionary.get("AngleMustBeBetween", "0", " \u03c0"));
        }
        if (this.pLabel1.length() == 0 || this.pLabel2.length() == 0) {
            logger.info((Object)("No end points: " + this.pLabel1 + ", " + this.pLabel2));
            throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
        }
        GPoint3d p1 = this.solid.getPoint(this.pLabel1);
        if (p1 == null) {
            logger.info((Object)("No point: " + this.pLabel1));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.pLabel1));
        }
        GPoint3d p2 = this.solid.getPoint(this.pLabel2);
        if (p2 == null) {
            logger.info((Object)("No point: " + this.pLabel2));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.pLabel2));
        }
        if (p1 == p2) {
            logger.info((Object)("Equal points: " + p1 + ", " + p2));
            throw new Exception(GDictionary.get("PointsRefNoLine", this.pLabel1, this.pLabel2));
        }
        Collection<GFace> faces = this.solid.facesThroughPoints(new String[]{this.pLabel1, this.pLabel2});
        Iterator<GFace> it = faces.iterator();
        if (faces.size() > 1) {
            if (this.fLabels == null) {
                String[] fLabelStrings = new String[2];
                for (int i = 0; i < 2; ++i) {
                    GFace face = it.next();
                    StringBuffer buf = new StringBuffer();
                    buf.append(face.labelAt(0)).append(face.labelAt(1)).append(face.labelAt(2));
                    fLabelStrings[i] = String.valueOf(buf);
                }
                throw new GUndefinedItemException(fLabelStrings);
            }
            this.face = this.solid.facesThroughPoints(this.fLabels).iterator().next();
        } else {
            this.face = it.next();
        }
        GLine line1 = this.face.lineThroughPoints(this.pLabel1, this.pLabel2);
        if (line1 == null) {
            logger.info((Object)("No line: " + this.pLabel1 + ", " + this.pLabel2));
            throw new Exception(GDictionary.get("NoLinePassesThroughPoints", this.pLabel1, this.pLabel2, this.figureName));
        }
        this.addedPoints = new ArrayList<GPoint3d>();
        this.addedLines = new ArrayList<GLine>();
        this.removedLines = new ArrayList<GLine>();
        Vector3d v = new Vector3d((Tuple3d)p2.coords);
        v.sub((Tuple3d)p1.coords);
        Vector3d n = this.face.getNormal(this.solid, this.solid.getGCenter());
        Vector3d[] vs = GMath.layAngle(v, n, angle);
        boolean outOfFace = true;
        for (int i = 0; i < 2; ++i) {
            Object[] result = this.face.intersectRay(p1.coords, vs[i], this.solid);
            if (result == null) continue;
            outOfFace = false;
            GLine line = (GLine)result[0];
            Point3d pCoords = (Point3d)result[1];
            GPoint3d p = this.solid.getPoint(pCoords);
            if (p == null) {
                p = this.solid.addPoint(pCoords);
                GFace f = line.getFace();
                f.addPoint(p, this.solid);
                f = line.getTwin().getFace();
                f.addPoint(p, this.solid);
                this.addedPoints.add(p);
            } else {
                GLine l = this.face.lineThroughPoints(this.pLabel1, p.getLabel());
                if (l != null) continue;
            }
            ArrayList<GLine> rLines = new ArrayList<GLine>();
            this.addedLines.add(this.face.addLine(p1, p, rLines, this.solid));
            this.removedLines.addAll(rLines);
        }
        if (this.addedLines.isEmpty()) {
            if (outOfFace) {
                logger.info((Object)("Outside figure: " + this.pLabel1 + ", " + this.pLabel2 + ", " + angle));
                throw new Exception(GDictionary.get("AngleIsOutsideFigure", this.figureName));
            }
            logger.info((Object)("Already drawn: " + this.pLabel1 + ", " + this.pLabel2 + ", " + angle));
            throw new Exception(GDictionary.get("AngleAlreadyDrawnInFigure", this.figureName));
        }
        this.solid.makeConfig();
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        for (GPoint3d p : this.addedPoints) {
            Collection<GFace> faces = this.solid.facesThroughPoint(p.getLabel());
            for (GFace face : faces) {
                face.removePoint(p);
            }
            this.solid.removePoint(p.getLabel());
        }
        this.face.undoAddLines(this.addedLines, this.removedLines);
        this.solid.makeConfig();
        this.figure.repaint();
        this.document.setSelectedFigure(this.figureName);
        logger.info((Object)(this.figureName + ", " + this.angleString + ", " + this.pLabel1 + ", " + this.pLabel2 + ", "));
    }

    @Override
    public GLoggable clone() {
        GLayAngleAction action = new GLayAngleAction();
        action.figureName = this.figureName;
        if (this.fLabels != null) {
            action.fLabels = this.fLabels;
            for (int i = 0; i < 3; ++i) {
                action.fLabels[i] = this.fLabels[i];
            }
        }
        action.angleString = this.angleString;
        action.pLabel1 = this.pLabel1;
        action.pLabel2 = this.pLabel2;
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("LayAngleOffLineInFigure", this.angleString, this.pLabel1 + this.pLabel2, this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("fLabel1");
        if (ns.getLength() > 0) {
            this.fLabels = new String[3];
            this.fLabels[0] = ns.item(0).getTextContent();
            ns = node.getElementsByTagName("fLabel2");
            if (ns.getLength() == 0) {
                logger.error((Object)"No fLabel2");
                throw new Exception();
            }
            this.fLabels[1] = ns.item(0).getTextContent();
            ns = node.getElementsByTagName("fLabel3");
            if (ns.getLength() == 0) {
                logger.error((Object)"No fLabel3");
                throw new Exception();
            }
            this.fLabels[2] = ns.item(0).getTextContent();
        }
        if ((ns = node.getElementsByTagName("angle")).getLength() == 0) {
            logger.error((Object)"No angle");
            throw new Exception();
        }
        this.angleString = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.pLabel1 = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.pLabel2 = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<angle>").append(this.angleString).append("</angle>");
        if (this.fLabels != null) {
            buf.append("\n<fLabel1>").append(this.fLabels[0]).append("</fLabel1>").append("\n<fLabel2>").append(this.fLabels[1]).append("</fLabel2>").append("\n<fLabel3>").append(this.fLabels[2]).append("</fLabel3>");
        }
        buf.append("\n<p1Label>").append(this.pLabel1).append("</p1Label>").append("\n<p2Label>").append(this.pLabel2).append("</p2Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p1String, String p2String, String angleString, String fLabelsString) {
        logger.info((Object)(p1String + ", " + p2String + ", " + angleString + ", " + fLabelsString));
        this.pLabel1 = p1String.toUpperCase();
        this.pLabel2 = p2String.toUpperCase();
        this.angleString = angleString;
        if (fLabelsString != null) {
            this.fLabels = new String[3];
            StringBuffer buf = new StringBuffer();
            buf.append("(").append("[A-Z][0-9]*").append(")").append("(").append("[A-Z][0-9]*").append(")").append("(").append("[A-Z][0-9]*").append(")");
            Pattern pattern = Pattern.compile(String.valueOf(buf));
            Matcher matcher = pattern.matcher(fLabelsString);
            matcher.matches();
            for (int i = 0; i < 3; ++i) {
                this.fLabels[i] = matcher.group(i + 1);
            }
        }
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("layAngleOffLine", this.angleString, this.pLabel1 + this.pLabel2);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

