/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GNoMoreJoinMatchesException;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GUndefinedJoinException;
import net.geocentral.geometria.view.GJoinDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GJoinAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private GDocument document;
    private String figure1Name;
    private String figure2Name;
    private String jointFigureName;
    private String[] matchLabels1;
    private String[] matchLabels2;
    private GSolid solid1;
    private GSolid solid2;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        this.document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply(null);
            }
            catch (Exception exception) {
                logger.error((Object)GStringUtils.stackTraceToString(exception));
                return false;
            }
        } else {
            List<String> figureNames = this.document.getFigureNames();
            String[] figureNamesArray = new String[figureNames.size()];
            figureNames.toArray(figureNamesArray);
            GJoinDialog dialog = new GJoinDialog(documentHandler.getOwnerFrame(), this, figureNamesArray);
            String figureName = this.document.getSelectedFigure().getName();
            dialog.prefill(figureName);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
        }
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)String.format("%s, %s, %s, %s, %s", this.figure1Name, this.figure2Name, Arrays.asList(this.matchLabels1), Arrays.asList(this.matchLabels2), this.jointFigureName));
        return true;
    }

    public void setFigureNames(String figure1Name, String figure2Name) {
        logger.info((Object)(figure1Name + ", " + figure2Name));
        this.figure1Name = figure1Name;
        this.figure2Name = figure2Name;
    }

    public void setMatchLabels(String[] labels1, String[] labels2) {
        logger.info((Object)(Arrays.asList(labels1) + ", " + Arrays.asList(labels2)));
        this.matchLabels1 = labels1;
        this.matchLabels2 = labels2;
    }

    public void validateApply(GJoinDialog dialog) throws Exception {
        GFigure figure;
        logger.info((Object)"");
        GFace face1 = null;
        GFace face2 = null;
        int matchIndex = -1;
        Map<GFace, Map<GFace, List<Integer>>> joinMatches = null;
        if (this.matchLabels1 == null) {
            List<Integer> matchIndexes;
            Map<GFace, List<Integer>> face1Matches;
            figure = this.document.getFigure(this.figure1Name);
            this.solid1 = figure.getSolid();
            figure = this.document.getFigure(this.figure2Name);
            this.solid2 = figure.getSolid();
            joinMatches = this.solid1.getJoinMatches(this.solid2);
            if (joinMatches.isEmpty()) {
                logger.info((Object)("Cannot be joined: " + this.figure1Name + ", " + this.figure2Name));
                throw new Exception(GDictionary.get("FiguresCannotBeJoined", this.figure1Name, this.figure2Name));
            }
            if (joinMatches.keySet().size() == 1 && (face1Matches = joinMatches.get(face1 = joinMatches.keySet().iterator().next())).keySet().size() == 1 && (matchIndexes = face1Matches.get(face2 = face1Matches.keySet().iterator().next())).size() == 1) {
                matchIndex = matchIndexes.get(0);
            }
            Set<GSelectable> selection = this.solid1.getSelection();
            LinkedHashSet<GFace> faces1 = new LinkedHashSet<GFace>();
            LinkedHashSet<GPoint3d> ps1 = new LinkedHashSet<GPoint3d>();
            for (GSelectable element : selection) {
                if (element instanceof GFace) {
                    faces1.add((GFace)element);
                    continue;
                }
                if (!(element instanceof GPoint3d)) continue;
                ps1.add((GPoint3d)element);
            }
            if (faces1.size() > 1) {
                logger.info((Object)("More than 1 face selected: " + this.figure1Name));
                throw new Exception(GDictionary.get("MoreThanOneFaceSelected", this.figure1Name));
            }
            if (ps1.size() > 1) {
                logger.info((Object)("More than 1 reference point selected: " + this.figure1Name));
                throw new Exception(GDictionary.get("MoreThanOneRefPointSelected", this.figure1Name));
            }
            GFace selectedFace1 = faces1.isEmpty() ? null : (GFace)faces1.iterator().next();
            GPoint3d selectedPoint1 = ps1.isEmpty() ? null : (GPoint3d)ps1.iterator().next();
            int selectedIndex1 = -1;
            if (selectedPoint1 != null) {
                if (!selectedPoint1.isVertex()) {
                    logger.info((Object)("Not vertex: " + selectedPoint1 + ", " + this.figure1Name));
                    throw new Exception(GDictionary.get("SelectedPointIsNotVertex", selectedPoint1.getLabel(), this.figure1Name));
                }
                if (selectedFace1 != null) {
                    for (int i = 0; i < selectedFace1.sideCount(); ++i) {
                        if (!selectedFace1.labelAt(i).equals(selectedPoint1.getLabel())) continue;
                        selectedIndex1 = i;
                        break;
                    }
                    if (selectedIndex1 < 0) {
                        logger.info((Object)String.format("Not in selected face: %s, %s, %s", selectedPoint1, selectedFace1, this.figure1Name));
                        throw new Exception(GDictionary.get("SelectedPointNotInSelectedFace", selectedPoint1.getLabel(), this.figure1Name));
                    }
                }
            }
            selection = this.solid2.getSelection();
            LinkedHashSet<GFace> faces2 = new LinkedHashSet<GFace>();
            LinkedHashSet<GPoint3d> ps2 = new LinkedHashSet<GPoint3d>();
            for (GSelectable element : selection) {
                if (element instanceof GFace) {
                    faces2.add((GFace)element);
                    continue;
                }
                if (!(element instanceof GPoint3d)) continue;
                ps2.add((GPoint3d)element);
            }
            if (faces2.size() > 1) {
                logger.info((Object)("More than 1 face selected: " + this.figure2Name));
                throw new Exception(GDictionary.get("MoreThanOneFaceSelected", this.figure2Name));
            }
            if (ps2.size() > 1) {
                logger.info((Object)("More than 1 reference point selected: " + this.figure2Name));
                throw new Exception(GDictionary.get("MoreThanOneRefPointSelected", this.figure2Name));
            }
            GFace selectedFace2 = faces2.isEmpty() ? null : (GFace)faces2.iterator().next();
            GPoint3d selectedPoint2 = ps2.isEmpty() ? null : (GPoint3d)ps2.iterator().next();
            int selectedIndex2 = -1;
            if (selectedPoint2 != null) {
                if (!selectedPoint2.isVertex()) {
                    logger.info((Object)("Not vertex: " + selectedPoint2 + ", " + this.figure2Name));
                    throw new Exception(GDictionary.get("SelectedPointIsNotVertex", selectedPoint2.getLabel(), this.figure2Name));
                }
                if (selectedFace2 != null) {
                    for (int i = 0; i < selectedFace2.sideCount(); ++i) {
                        if (!selectedFace2.labelAt(i).equals(selectedPoint2.getLabel())) continue;
                        selectedIndex2 = i;
                        break;
                    }
                    if (selectedIndex2 < 0) {
                        logger.info((Object)String.format("Not in selected face: %s, %s, %s", selectedPoint2, selectedFace2, this.figure2Name));
                        throw new Exception(GDictionary.get("SelectedPointNotInSelectedFace", selectedPoint2.getLabel(), this.figure2Name));
                    }
                }
            }
            if (selectedFace1 != null) {
                joinMatches.keySet().retainAll(faces1);
                if (joinMatches.isEmpty()) {
                    logger.info((Object)String.format("Cannot be joined at face: %s, %s", selectedFace1, this.figure1Name));
                    throw new Exception(GDictionary.get("FiguresCannotBeJoinedAtSelectedFaces", this.figure1Name, this.figure2Name));
                }
            }
            if (selectedFace2 != null) {
                LinkedHashSet<GFace> unmatchedFaces1 = new LinkedHashSet<GFace>();
                for (GFace f1 : joinMatches.keySet()) {
                    Map<GFace, List<Integer>> f1Matches = joinMatches.get(f1);
                    f1Matches.keySet().retainAll(faces2);
                    if (!f1Matches.isEmpty()) continue;
                    unmatchedFaces1.add(f1);
                }
                joinMatches.keySet().removeAll(unmatchedFaces1);
                if (joinMatches.isEmpty()) {
                    logger.info((Object)String.format("Cannot be joined at faces: %s, %s, %s, %s", selectedFace1, this.figure1Name, selectedFace2, this.figure2Name));
                    throw new Exception(GDictionary.get("FiguresCannotBeJoinedAtSelectedFaces", this.figure1Name, this.figure2Name));
                }
            }
            if (selectedIndex1 >= 0 && selectedIndex2 >= 0) {
                List<Integer> matchIndexes2 = joinMatches.get(selectedFace1).get(selectedFace2);
                int sc = selectedFace1.sideCount();
                boolean flipFace2 = selectedFace1.getOrientation(this.solid1, this.solid1.getGCenter()) == selectedFace2.getOrientation(this.solid2, this.solid2.getGCenter());
                int selectedMatchIndex = flipFace2 ? (selectedIndex1 + selectedIndex2) % sc : (selectedIndex1 - selectedIndex2 + sc) % sc;
                if (!matchIndexes2.contains(selectedMatchIndex)) {
                    logger.info((Object)String.format("Cannot be joined at points: %s, %d", String.valueOf(matchIndexes2), selectedMatchIndex));
                    throw new Exception(GDictionary.get("FiguresCannotBeJoinedAtSelectedPoints", this.figure1Name, this.figure2Name));
                }
                matchIndex = selectedMatchIndex;
                face1 = selectedFace1;
                face2 = selectedFace2;
            } else if (matchIndex < 0) {
                int option = GGraphicsFactory.getInstance().showQuestionDialog(GDictionary.get("JoinAnyMatchingFaces", new String[0]), 0, GGraphicsFactory.LocationType.TOP_LEFT);
                logger.info((Object)option);
                if (option != 0) {
                    GGraphicsFactory.getInstance().showMessageDialog(GDictionary.get("SelectFaceRefPoint", new String[0]));
                    throw new GUndefinedJoinException();
                }
            }
        } else {
            figure = this.document.getFigure(this.figure1Name);
            this.solid1 = figure.getSolid();
            figure = this.document.getFigure(this.figure2Name);
            this.solid2 = figure.getSolid();
            face1 = this.solid1.getFace(this.matchLabels1);
            face2 = this.solid2.getFace(this.matchLabels2);
            int index1 = -1;
            for (int i = 0; i < face1.sideCount(); ++i) {
                if (!face1.labelAt(i).equals(this.matchLabels1[0])) continue;
                index1 = i;
                break;
            }
            if (index1 == -1) {
                logger.info((Object)String.format("No point: %s, %s", this.matchLabels1[0], this.figure1Name));
                throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figure1Name, this.matchLabels1[0]));
            }
            int index2 = -1;
            for (int i = 0; i < face2.sideCount(); ++i) {
                if (!face2.labelAt(i).equals(this.matchLabels2[0])) continue;
                index2 = i;
                break;
            }
            if (index2 == -1) {
                logger.info((Object)String.format("No point: %s, %s", this.matchLabels2[0], this.figure2Name));
                throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figure2Name, this.matchLabels2[0]));
            }
            int sc = face1.sideCount();
            boolean flipFace2 = face1.getOrientation(this.solid1, this.solid1.getGCenter()) == face2.getOrientation(this.solid2, this.solid2.getGCenter());
            matchIndex = flipFace2 ? (index1 + index2) % sc : (index1 - index2 + sc) % sc;
        }
        GSolid solid = null;
        if (matchIndex >= 0) {
            solid = this.solid1.join(this.solid2, face1, face2, matchIndex);
            if (solid == null) {
                logger.info((Object)("Not convex: " + this.figure1Name + ", " + this.figure1Name));
                throw new Exception(GDictionary.get("FiguresCannotBeJoinedNotConvex", this.figure1Name, this.figure2Name));
            }
            this.showMatch(face1, face2, matchIndex, solid);
        } else {
            ArrayList<GSolid> solids = new ArrayList<GSolid>();
            for (GFace f1 : joinMatches.keySet()) {
                Map<GFace, List<Integer>> f1Matches = joinMatches.get(f1);
                for (GFace f2 : f1Matches.keySet()) {
                    List<Integer> matchIndexes = f1Matches.get(f2);
                    for (int mIndex : matchIndexes) {
                        solid = this.solid1.join(this.solid2, f1, f2, mIndex);
                        if (solid == null) continue;
                        boolean duplicate = false;
                        for (GSolid s : solids) {
                            if (!solid.isSimilar(s)) continue;
                            duplicate = true;
                            solid = null;
                            break;
                        }
                        if (duplicate) continue;
                        solids.add(solid);
                        face1 = f1;
                        face2 = f2;
                        matchIndex = mIndex;
                        this.showMatch(face1, face2, matchIndex, solid);
                        int option = GGraphicsFactory.getInstance().showQuestionDialog(GDictionary.get("KeepThisResult", new String[0]), 1, GGraphicsFactory.LocationType.TOP_LEFT);
                        if (option == 0) {
                            return;
                        }
                        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
                        this.undo(documentHandler);
                        solid = null;
                        if (option == 1 || option != 2) continue;
                        throw new GUndefinedJoinException();
                    }
                }
            }
            if (solid == null) {
                logger.info((Object)"No more matches");
                GGraphicsFactory.getInstance().showErrorDialog(GDictionary.get("NoMoreMatches", new String[0]));
                throw new GNoMoreJoinMatchesException();
            }
        }
    }

    void showMatch(GFace face1, GFace face2, int matchIndex, GSolid solid) {
        this.matchLabels1 = new String[3];
        this.matchLabels2 = new String[3];
        int sc = face1.sideCount();
        boolean flipFace2 = face1.getOrientation(this.solid1, this.solid1.getGCenter()) == face2.getOrientation(this.solid2, this.solid2.getGCenter());
        for (int i = 0; i < 3; ++i) {
            this.matchLabels1[i] = face1.labelAt((matchIndex + i) % sc);
            this.matchLabels2[i] = flipFace2 ? face2.labelAt((sc - i) % sc) : face2.labelAt(i);
        }
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GFigure figure1 = this.document.getFigure(this.figure1Name);
        GFigure jointFigure = documentHandler.newFigure(solid);
        jointFigure.setTransparent(figure1.isTransparent());
        jointFigure.setLabelled(figure1.isLabelled());
        Matrix3d attitude = new Matrix3d(figure1.getCamera().getAttitude());
        jointFigure.getCamera().setAttitude(attitude);
        Color baseColor = figure1.getBaseColor();
        jointFigure.setBaseColor(new Color(baseColor.getRGB()));
        this.jointFigureName = jointFigure.getName();
    }

    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid1.clearSelection();
        this.solid2.clearSelection();
        documentHandler.removeFigure(this.jointFigureName);
        this.document.removeFigure(this.jointFigureName);
        this.document.setSelectedFigure(this.figure1Name);
        logger.info((Object)("Join figures " + this.figure1Name + ", " + this.figure2Name + " into figure " + this.jointFigureName + " undone"));
        logger.info((Object)(this.figure1Name + ", " + this.figure2Name + ", " + Arrays.asList(this.matchLabels1) + ", " + Arrays.asList(this.matchLabels2) + this.jointFigureName));
    }

    public GLoggable clone() {
        GJoinAction action = new GJoinAction();
        action.figure1Name = this.figure1Name;
        action.figure2Name = this.figure2Name;
        action.jointFigureName = this.jointFigureName;
        action.matchLabels1 = (String[])this.matchLabels1.clone();
        action.matchLabels2 = (String[])this.matchLabels2.clone();
        return action;
    }

    public String toLogString() {
        return GDictionary.get("JoinFiguresAtPoints", this.figure1Name, this.figure2Name, this.matchLabels1[0], this.matchLabels1[1], this.matchLabels1[2], this.matchLabels2[0], this.matchLabels2[1], this.matchLabels2[2]);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figure1Name");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure1 name");
            throw new Exception();
        }
        this.figure1Name = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("figure2Name");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure2 name");
            throw new Exception();
        }
        this.figure2Name = ns.item(0).getTextContent();
        this.matchLabels1 = new String[3];
        this.matchLabels2 = new String[3];
        ns = node.getElementsByTagName("matchLabel10");
        if (ns.getLength() == 0) {
            logger.error((Object)"No matchLabel10");
            throw new Exception();
        }
        this.matchLabels1[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("matchLabel11");
        if (ns.getLength() == 0) {
            logger.error((Object)"No matchLabel11");
            throw new Exception();
        }
        this.matchLabels1[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("matchLabel12");
        if (ns.getLength() == 0) {
            logger.error((Object)"No matchLabel12");
            throw new Exception();
        }
        this.matchLabels1[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("matchLabel20");
        if (ns.getLength() == 0) {
            logger.error((Object)"No matchLabel20");
            throw new Exception();
        }
        this.matchLabels2[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("matchLabel21");
        if (ns.getLength() == 0) {
            logger.error((Object)"No matchLabel21");
            throw new Exception();
        }
        this.matchLabels2[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("matchLabel22");
        if (ns.getLength() == 0) {
            logger.error((Object)"No matchLabel22");
            throw new Exception();
        }
        this.matchLabels2[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figure1Name>").append(this.figure1Name).append("</figure1Name>").append("\n<figure2Name>").append(this.figure2Name).append("</figure2Name>").append("\n<matchLabel10>").append(this.matchLabels1[0]).append("</matchLabel10>").append("\n<matchLabel11>").append(this.matchLabels1[1]).append("</matchLabel11>").append("\n<matchLabel12>").append(this.matchLabels1[2]).append("</matchLabel12>").append("\n<matchLabel20>").append(this.matchLabels2[0]).append("</matchLabel20>").append("\n<matchLabel21>").append(this.matchLabels2[1]).append("</matchLabel21>").append("\n<matchLabel22>").append(this.matchLabels2[2]).append("</matchLabel22>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public String getShortDescription() {
        return GDictionary.get("joinFigures", this.figure1Name, this.figure2Name);
    }

    public String getFigureName() {
        return this.jointFigureName;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

