/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.vecmath.Point3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GIntersectDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GIntersectAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String[] pLabels;
    private GDocument document;
    private GFigure figure;
    private GSolid solid;
    private String intersectionLabel;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        GSolid solid;
        GDocumentHandler documentHandler;
        block6: {
            logger.info((Object)silent);
            documentHandler = GDocumentHandler.getInstance();
            this.document = documentHandler.getActiveDocument();
            if (silent) {
                try {
                    this.validateApply();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                GIntersectDialog dialog = new GIntersectDialog(documentHandler.getOwnerFrame(), this);
                dialog.prefill(this.pLabels);
                dialog.setVisible(true);
                if (dialog.getResult()) break block6;
                return false;
            }
        }
        solid.clearSelection();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + Arrays.asList(this.pLabels)));
        return true;
    }

    private void prefill(Set<GSelectable> selection) {
        logger.info(selection);
        this.pLabels = new String[4];
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 2) {
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GStick && element2 instanceof GStick) {
                this.pLabels[0] = ((GStick)element1).label1;
                this.pLabels[1] = ((GStick)element1).label2;
                this.pLabels[2] = ((GStick)element2).label1;
                this.pLabels[3] = ((GStick)element2).label2;
            }
        }
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        GPoint3d[] ps = new GPoint3d[4];
        for (int i = 0; i < 4; ++i) {
            if (this.pLabels[i].length() == 0) {
                logger.info((Object)("No end points: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
            }
            ps[i] = this.solid.getPoint(this.pLabels[i]);
            if (ps[i] != null) continue;
            logger.info((Object)("No point: " + this.pLabels[i]));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.pLabels[i]));
        }
        if (ps[0] == ps[1]) {
            logger.info((Object)("Equal points: " + ps[0] + ", " + ps[1]));
            throw new Exception(GDictionary.get("PointsRefNoLine", this.pLabels[0], this.pLabels[1]));
        }
        if (ps[2] == ps[3]) {
            logger.info((Object)("Equal points: " + ps[2] + ", " + ps[3]));
            throw new Exception(GDictionary.get("PointsRefNoLine", this.pLabels[2], this.pLabels[3]));
        }
        Collection<GFace> faces = this.solid.facesThroughPoints(this.pLabels);
        if (faces.isEmpty()) {
            logger.info((Object)("Do not intersect: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("LinesDoNotIntersect", this.pLabels[0] + this.pLabels[1], this.pLabels[2] + this.pLabels[3], this.figureName));
        }
        GFace face = faces.iterator().next();
        GLine line1 = face.lineThroughPoints(this.pLabels[0], this.pLabels[1]);
        if (line1 == null) {
            logger.info((Object)("No line: " + this.pLabels[0] + ", " + this.pLabels[1]));
            throw new Exception(GDictionary.get("NoLinePassesThroughPoints", this.pLabels[0], this.pLabels[1], this.figureName));
        }
        GLine line2 = face.lineThroughPoints(this.pLabels[2], this.pLabels[3]);
        if (line2 == null) {
            logger.info((Object)("No line: " + this.pLabels[2] + ", " + this.pLabels[3]));
            throw new Exception(GDictionary.get("NoLinePassesThroughPoints", this.pLabels[2], this.pLabels[3], this.figureName));
        }
        Point3d intersectionCoords = GMath.intersect(ps[0].coords, ps[1].coords, ps[2].coords, ps[3].coords, this.solid.getEpsilon());
        if (intersectionCoords == null) {
            logger.info((Object)("Do not intersect: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("LinesDoNotIntersect", this.pLabels[0] + this.pLabels[1], this.pLabels[2] + this.pLabels[3], this.figureName));
        }
        if (!face.covers(intersectionCoords, this.solid)) {
            logger.info((Object)("Intersect outside: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("LinesIntersectOutsideFigure", this.pLabels[0] + this.pLabels[1], this.pLabels[2] + this.pLabels[3], this.figureName));
        }
        GPoint3d p = this.solid.getPoint(intersectionCoords);
        if (p != null) {
            logger.info((Object)("Already intersected: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("LinesAlreadyIntersected", this.pLabels[0] + this.pLabels[1], this.pLabels[2] + this.pLabels[3], this.figureName));
        }
        p = this.solid.addPoint(intersectionCoords);
        this.intersectionLabel = p.getLabel();
        line1.addPoint(p, this.solid);
        line2.addPoint(p, this.solid);
        faces = this.solid.facesThroughPoints(new String[]{this.pLabels[0], this.pLabels[1]});
        for (GFace f : faces) {
            if (f == face) continue;
            f.addPoint(p, this.solid);
        }
        faces = this.solid.facesThroughPoints(new String[]{this.pLabels[2], this.pLabels[3]});
        for (GFace f : faces) {
            if (f == face) continue;
            f.addPoint(p, this.solid);
        }
        this.solid.makeConfig();
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getFigure(this.figureName);
        GSolid solid = figure.getSolid();
        GPoint3d p = solid.getPoint(this.intersectionLabel);
        Collection<GFace> faces = solid.facesThroughPoints(new String[]{this.pLabels[0], this.pLabels[1]});
        faces.addAll(solid.facesThroughPoints(new String[]{this.pLabels[2], this.pLabels[3]}));
        for (GFace face : faces) {
            face.removePoint(p);
        }
        solid.removePoint(this.intersectionLabel);
        solid.makeConfig();
        figure.repaint();
        document.setSelectedFigure(this.figureName);
        logger.info((Object)(this.figureName + ", " + Arrays.asList(this.pLabels)));
    }

    @Override
    public GLoggable clone() {
        GIntersectAction action = new GIntersectAction();
        action.figureName = this.figureName;
        action.pLabels = new String[4];
        for (int i = 0; i < 4; ++i) {
            action.pLabels[i] = this.pLabels[i];
        }
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("IntersectLinesInFigure", this.pLabels[0] + this.pLabels[1], this.pLabels[2] + this.pLabels[3], this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        this.pLabels = new String[4];
        ns = node.getElementsByTagName("p11Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p11Label");
            throw new Exception();
        }
        this.pLabels[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p12Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p12Label");
            throw new Exception();
        }
        this.pLabels[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p21Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p21Label");
            throw new Exception();
        }
        this.pLabels[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p22Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p22Label");
            throw new Exception();
        }
        this.pLabels[3] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<p11Label>").append(this.pLabels[0]).append("</p11Label>").append("\n<p12Label>").append(this.pLabels[1]).append("</p12Label>").append("\n<p21Label>").append(this.pLabels[2]).append("</p21Label>").append("\n<p22Label>").append(this.pLabels[3]).append("</p22Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p11String, String p12String, String p21String, String p22String) {
        logger.info((Object)(p11String + ", " + p12String + ", " + p21String + ", " + p22String));
        this.pLabels[0] = p11String.toUpperCase();
        this.pLabels[1] = p12String.toUpperCase();
        this.pLabels[2] = p21String.toUpperCase();
        this.pLabels[3] = p22String.toUpperCase();
    }

    @Override
    public String getShortDescription() {
        logger.info((Object)"");
        return GDictionary.get("intersectLines", this.pLabels[0] + this.pLabels[1], this.pLabels[2] + this.pLabels[3]);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

