/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEraseSelectionAction
implements GLoggable,
GFigureAction {
    private String figureName;
    private List<String> pointLabels;
    private List<StringPair> stickLabels;
    private GDocument document;
    private GFigure figure;
    private GSolid solid;
    private Map<GFace, List<GLine>> removedLines;
    private Map<GPoint3d, List<GLine>> removedPoints;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)"");
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        this.document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        }
        GFigure figure = this.document.getSelectedFigure();
        this.figureName = figure.getName();
        GSolid solid = figure.getSolid();
        Set<GSelectable> selection = solid.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        this.pointLabels = new ArrayList<String>();
        this.stickLabels = new ArrayList<StringPair>();
        for (GSelectable element : selection) {
            if (element instanceof GStick) {
                StringPair sp = new StringPair(((GStick)element).label1, ((GStick)element).label2);
                this.stickLabels.add(sp);
                continue;
            }
            if (!(element instanceof GPoint3d)) continue;
            this.pointLabels.add(((GPoint3d)element).getLabel());
        }
        try {
            this.validateApply();
        }
        catch (Exception exception) {
            GGraphicsFactory.getInstance().showErrorDialog(exception.getMessage());
            return false;
        }
        solid.clearSelection();
        this.document.getNotepad().selectionErased(this);
        documentHandler.notepadChanged();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.pointLabels + ", " + this.stickLabels));
        return true;
    }

    public void validateApply() throws Exception {
        Collection<GFace> faces;
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        this.removedLines = new LinkedHashMap<GFace, List<GLine>>();
        for (StringPair sp : this.stickLabels) {
            faces = this.solid.facesThroughPoints(new String[]{sp.s1, sp.s2});
            if (faces.size() > 1) {
                logger.info((Object)("Edge: " + sp));
                throw new Exception(GDictionary.get("CannotEraseEdgeInFigure", sp.s1 + sp.s2, this.figureName));
            }
            GFace face = faces.iterator().next();
            List<GLine> removedLs = this.removedLines.get(face);
            if (this.removedLines.get(face) == null) {
                removedLs = new ArrayList<GLine>();
                this.removedLines.put(face, removedLs);
            }
            GLine line = face.lineThroughPoints(sp.s1, sp.s2);
            removedLs.add(line);
        }
        this.removedPoints = new LinkedHashMap<GPoint3d, List<GLine>>();
        for (String s : this.pointLabels) {
            GPoint3d p = this.solid.getPoint(s);
            this.removedPoints.put(p, null);
        }
        for (String label : this.pointLabels) {
            faces = this.solid.facesThroughPoint(label);
            for (GFace face : faces) {
                List<GLine> lines = face.linesThroughPoint(label);
                List<GLine> removedLs = this.removedLines.get(face);
                if (removedLs != null) {
                    lines.removeAll(removedLs);
                }
                for (GLine line : lines) {
                    if (!line.firstLabel().equals(label) && !line.lastLabel().equals(label)) continue;
                    logger.info((Object)("End of line: " + label));
                    throw new Exception(GDictionary.get("CannotEraseEndOfLineInFigure", label, this.figureName));
                }
            }
        }
        LinkedHashSet<GPoint3d> danglingPoints = new LinkedHashSet<GPoint3d>();
        for (GFace face : this.removedLines.keySet()) {
            List<GLine> removedLs = this.removedLines.get(face);
            for (GLine line : removedLs) {
                ArrayList<String> danglingLabels = new ArrayList<String>();
                face.removeLine(line, danglingLabels);
                for (String label : danglingLabels) {
                    danglingPoints.add(this.solid.getPoint(label));
                }
            }
        }
        for (GPoint3d p : this.removedPoints.keySet()) {
            ArrayList<GLine> affectedLines = new ArrayList<GLine>();
            Collection<GFace> faces2 = this.solid.facesThroughPoint(p.getLabel());
            for (GFace face : faces2) {
                List<GLine> lines = face.linesThroughPoint(p.getLabel());
                if (lines.isEmpty()) continue;
                List<GLine> removedLs = this.removedLines.get(face);
                if (removedLs != null) {
                    lines.removeAll(removedLs);
                }
                affectedLines.addAll(lines);
            }
            if (!affectedLines.isEmpty()) {
                for (GLine line : affectedLines) {
                    line.remove(p.getLabel());
                }
                this.removedPoints.put(p, affectedLines);
            }
            this.solid.removePoint(p.getLabel());
        }
        for (GPoint3d p : danglingPoints) {
            this.solid.removePoint(p.getLabel());
            this.removedPoints.put(p, null);
        }
        this.solid.makeConfig();
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        for (GPoint3d p : this.removedPoints.keySet()) {
            this.solid.undoRemovePoint(p);
        }
        for (GFace face : this.removedLines.keySet()) {
            List<GLine> removedLs = this.removedLines.get(face);
            for (GLine line : removedLs) {
                face.addLine(line);
            }
        }
        for (GPoint3d p : this.removedPoints.keySet()) {
            List<GLine> affectedLines = this.removedPoints.get(p);
            if (affectedLines == null) continue;
            for (GLine line : affectedLines) {
                line.insert(p, this.solid);
            }
        }
        this.document.getNotepad().eraseSelectionUndone(this);
        documentHandler.notepadChanged();
        this.solid.makeConfig();
        this.figure.repaint();
        this.document.setSelectedFigure(this.figureName);
        logger.info((Object)(this.figureName + ", " + this.pointLabels + ", " + this.stickLabels));
    }

    @Override
    public GLoggable clone() {
        GEraseSelectionAction action = new GEraseSelectionAction();
        action.figureName = this.figureName;
        action.pointLabels = new ArrayList<String>();
        for (String label : this.pointLabels) {
            action.pointLabels.add(label);
        }
        action.stickLabels = new ArrayList<StringPair>();
        for (StringPair sp : this.stickLabels) {
            action.stickLabels.add(new StringPair(sp.s1, sp.s2));
        }
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("EraseSelectedElementsInFigure", this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("pLabel");
        this.pointLabels = new ArrayList<String>();
        for (int i = 0; i < ns.getLength(); ++i) {
            String label = ns.item(i).getTextContent();
            this.pointLabels.add(label);
        }
        NodeList nns = node.getElementsByTagName("sLabels");
        this.stickLabels = new ArrayList<StringPair>();
        for (int i = 0; i < nns.getLength(); ++i) {
            String value = nns.item(i).getTextContent();
            String[] tokens = value.split(" ");
            if (tokens.length != 2) {
                logger.error(Arrays.asList(tokens));
                throw new Exception();
            }
            StringPair sp = new StringPair(tokens[0], tokens[1]);
            this.stickLabels.add(sp);
        }
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>");
        for (String label : this.pointLabels) {
            buf.append("\n<pLabel>").append(label).append("</pLabel>");
        }
        for (StringPair sp : this.stickLabels) {
            buf.append("\n<sLabels>").append(sp.s1).append(" ").append(sp.s2).append("</sLabels>");
        }
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("eraseSelection", new String[0]);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    public Collection<GPoint3d> getRemovedPoints() {
        return this.removedPoints.keySet();
    }

    class StringPair {
        public String s1;
        public String s2;

        public StringPair(String s1, String s2) {
            this.s1 = s1;
            this.s2 = s2;
        }

        public String toString() {
            return this.s1 + ", " + this.s2;
        }
    }
}

