/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GUndoable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GDocumentEnvelope;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.view.GEnvelopeDialog;
import org.apache.log4j.Logger;

public class GEnvelopeAction
implements GUndoable,
GActionWithHelp {
    private GDocumentEnvelope oldEnvelope;
    private GDocumentEnvelope newEnvelope;
    private String helpId;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        if (silent) {
            document.setEnvelope(this.newEnvelope);
        } else {
            this.oldEnvelope = document.getEnvelope();
            GEnvelopeDialog dialog = new GEnvelopeDialog(documentHandler.getOwnerFrame(), document, this);
            dialog.setVisible(true);
            if (dialog.getOption() != 0) {
                return false;
            }
            this.newEnvelope = document.getEnvelope();
        }
        documentHandler.setDocumentModified(true);
        logger.info((Object)(this.oldEnvelope + ", " + this.newEnvelope));
        return true;
    }

    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        this.newEnvelope = document.getEnvelope().clone();
        document.setEnvelope(this.oldEnvelope);
        logger.info((Object)(this.oldEnvelope + ", " + this.newEnvelope));
    }

    public String getShortDescription() {
        return GDictionary.get("editEnvelope", new String[0]);
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

