/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import net.geocentral.geometria.action.GActionLoader;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.action.GUndoable;
import net.geocentral.geometria.event.GDocumentModifiedEvent;
import net.geocentral.geometria.event.GEventListener;
import net.geocentral.geometria.io.GFileReader;
import net.geocentral.geometria.io.GFileWriter;
import net.geocentral.geometria.model.GCalculator;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLabelFactory;
import net.geocentral.geometria.model.GLog;
import net.geocentral.geometria.model.GOptions;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GSolution;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GOptionsManager;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.util.GVersionManager;
import net.geocentral.geometria.view.GContainer;
import net.geocentral.geometria.view.GFrame;
import net.geocentral.geometria.view.GMainPanel;
import org.apache.log4j.Logger;

public class GDocumentHandler
implements GEventListener {
    public static final String SAMPLES = "samples";
    private static GDocumentHandler instance;
    private Map<String, AbstractAction> actionHandlers;
    private GContainer container;
    private GMainPanel mainPanel;
    private GCalculator calculator = new GCalculator();
    private GDocument activeDocument;
    private GSolution masterSolution;
    private boolean documentModified;
    private String title;
    private String problemPath;
    private String solutionPath;
    private String figurePath;
    private List<GUndoable> actions;
    private int actionIndex = -1;
    private boolean selectorOn = false;
    private static Logger logger;

    private GDocumentHandler() {
    }

    public static GDocumentHandler getInstance() {
        if (instance == null) {
            instance = new GDocumentHandler();
        }
        return instance;
    }

    public void init() throws Exception {
        this.setPaths();
        this.loadActions();
        this.updateActionHandlerStates();
    }

    private void setPaths() {
        File samplesDir;
        try {
            GOptions options = GOptionsManager.getInstance().getOptions();
            String language = options.getLanguage();
            samplesDir = new File(new File(new File(".").getCanonicalPath(), SAMPLES), language);
        }
        catch (Exception exception) {
            logger.error((Object)GStringUtils.stackTraceToString(exception));
            return;
        }
        this.figurePath = new File(samplesDir, GDictionary.get("figures", new String[0])).getPath();
        this.problemPath = new File(samplesDir, GDictionary.get("problems", new String[0])).getPath();
        this.solutionPath = new File(samplesDir, GDictionary.get("solutions", new String[0])).getPath();
    }

    private void loadActions() throws Exception {
        logger.info((Object)"");
        this.actionHandlers = new GActionLoader().loadActions();
        this.actions = new ArrayList<GUndoable>();
        this.actionIndex = -1;
    }

    public void updateActionHandlerStates() {
        logger.info((Object)"");
        GLog log = null;
        boolean logPlaying = false;
        if (this.activeDocument instanceof GSolution) {
            log = this.masterSolution.getLog();
            logPlaying = log.isPlaying();
        }
        this.getActionHandler("document.newProblem").setEnabled(!logPlaying);
        this.getActionHandler("document.newSolution").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("document.openProblem").setEnabled(!logPlaying);
        this.getActionHandler("document.openSolution").setEnabled(!logPlaying);
        this.getActionHandler("document.saveDocument").setEnabled(this.container instanceof GFrame && this.activeDocument != null && !logPlaying && this.documentModified);
        this.getActionHandler("document.saveDocumentAs").setEnabled(this.container instanceof GFrame && this.activeDocument != null && !logPlaying);
        this.getActionHandler("document.closeDocument").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("edit.undo").setEnabled(this.actionIndex > -1 && !logPlaying);
        this.getActionHandler("edit.undo").putValue("ShortDescription", this.getActionHandler("edit.undo").isEnabled() ? GDictionary.get("Undo", new String[0]) + " " + this.getCurrentAction().getShortDescription() : GDictionary.get("Undo", new String[0]));
        this.getActionHandler("edit.redo").setEnabled(this.actionIndex < this.actions.size() - 1 && !logPlaying);
        this.getActionHandler("edit.redo").putValue("ShortDescription", this.getActionHandler("edit.redo").isEnabled() ? GDictionary.get("Redo", new String[0]) + " " + this.getNextAction().getShortDescription() : GDictionary.get("Redo", new String[0]));
        this.getActionHandler("edit.answer").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("edit.envelope").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("edit.renameVariable").setEnabled(this.activeDocument != null && !this.activeDocument.getNotepad().getVariables().isEmpty());
        this.getActionHandler("edit.clearNotepad").setEnabled(this.activeDocument instanceof GProblem && !this.activeDocument.getNotepad().isEmpty());
        this.getActionHandler("edit.selectAll").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures());
        this.getActionHandler("figure.prism.3").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.prism.4").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.prism.5").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.prism.6").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.prism.N").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.pyramid.3").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.pyramid.4").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.pyramid.5").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.pyramid.6").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.pyramid.N").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.tetrahedron").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.cube").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.octahedron").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.dodecahedron").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.icosahedron").setEnabled(this.activeDocument != null && !logPlaying);
        this.getActionHandler("figure.open").setEnabled(this.activeDocument instanceof GProblem);
        this.getActionHandler("figure.clone").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("figure.save").setEnabled(this.container instanceof GFrame && this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("figure.exportOff").setEnabled(this.container instanceof GFrame && this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("figure.exportImage").setEnabled(this.container instanceof GFrame && this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("figure.rename").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && (this.activeDocument instanceof GProblem || !logPlaying && !((GSolution)this.activeDocument).isImported(this.activeDocument.getSelectedFigure())));
        this.getActionHandler("figure.remove").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && (this.activeDocument instanceof GProblem || !logPlaying && !((GSolution)this.activeDocument).isImported(this.activeDocument.getSelectedFigure())));
        this.getActionHandler("figure.print").setEnabled(this.container instanceof GFrame && this.activeDocument != null && this.activeDocument.hasFigures());
        this.getActionHandler("measure.distance").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("measure.angle").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("measure.area").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("measure.volume").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("transform.scale").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && (this.activeDocument instanceof GProblem || !logPlaying && !((GSolution)this.activeDocument).isImported(this.activeDocument.getSelectedFigure())));
        this.getActionHandler("transform.shear").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && (this.activeDocument instanceof GProblem || !logPlaying && !((GSolution)this.activeDocument).isImported(this.activeDocument.getSelectedFigure())));
        this.getActionHandler("transform.cut").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("transform.join").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.drawLine").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.drawPerpendicular").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.divideLine").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.drawMidpoint").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.divideAngle").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.drawBisector").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.intersectLines").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.layDistance").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.layAngle").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.renamePoint").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && this.activeDocument instanceof GProblem);
        this.getActionHandler("draw.eraseLine").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("draw.eraseSelection").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !logPlaying);
        this.getActionHandler("view.toggleSelector").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures());
        this.getActionHandler("view.zoomIn").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures());
        this.getActionHandler("view.zoomOut").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures());
        this.getActionHandler("view.fitToView").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures());
        this.getActionHandler("view.initialAttitude").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures());
        this.getActionHandler("view.defaultAttitude").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures());
        this.getActionHandler("view.toggleTransparency").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures());
        this.getActionHandler("view.toggleLabels").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && this.activeDocument.getSelectedFigure().isTransparent());
        this.getActionHandler("view.setColor").setEnabled(this.activeDocument != null && this.activeDocument.hasFigures() && !this.activeDocument.getSelectedFigure().isTransparent());
        this.getActionHandler("log.playBack").setEnabled(this.activeDocument instanceof GSolution && !logPlaying && !log.isEmpty());
        this.getActionHandler("log.stop").setEnabled(logPlaying);
        this.getActionHandler("log.next").setEnabled(logPlaying && log.getCurrentPos() < log.size() - 1);
        this.getActionHandler("log.clear").setEnabled(this.activeDocument instanceof GSolution && !log.isEmpty());
        this.getActionHandler("log.cut").setEnabled(logPlaying && log.getCurrentPos() >= 0 && log.getCurrentPos() < log.size() - 1);
        GOptions options = GOptionsManager.getInstance().getOptions();
        int fontSize = options.getFont().getSize();
        String actionName = String.format("options.font.%s", fontSize);
        this.getActionHandler(actionName).putValue("SwingSelectedKey", true);
        String language = options.getLanguage();
        actionName = String.format("options.language.%s", language);
        this.getActionHandler(actionName).putValue("SwingSelectedKey", true);
    }

    public boolean onCloseDocument() {
        GDocument document;
        logger.info((Object)"");
        if (!(this.container instanceof GFrame)) {
            return true;
        }
        GDocument gDocument = document = this.activeDocument instanceof GSolution ? this.masterSolution : this.activeDocument;
        if (document == null) {
            return true;
        }
        if (!this.documentModified) {
            return true;
        }
        int option = GGraphicsFactory.getInstance().showYesNoCancelDialog(GDictionary.get("SaveDocument", new String[0]));
        if (option == 0) {
            try {
                if (this.saveDocument()) {
                    return true;
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Could not save document. Closing cancelled");
                return false;
            }
        }
        return option == 1;
    }

    public boolean saveDocument() {
        String filePath;
        logger.info((Object)"");
        GDocument document = this.activeDocument instanceof GSolution ? this.masterSolution : this.activeDocument;
        String string = filePath = document instanceof GProblem ? this.problemPath : this.solutionPath;
        if (document.isPrime() || filePath == null) {
            return this.saveDocumentAs();
        }
        StringBuffer buf = new StringBuffer();
        document.serialize(buf, true);
        FileFilter[] fileFilters = new FileFilter[]{};
        GFileWriter writer = this.getFileWriter(this.getOwnerFrame(), filePath, fileFilters, false);
        try {
            writer.write(String.valueOf(buf));
        }
        catch (Exception exception) {
            this.error(exception);
            return false;
        }
        document.setPrime(false);
        this.setDocumentModified(false);
        logger.info((Object)filePath);
        return true;
    }

    public boolean saveDocumentAs() {
        logger.info((Object)"");
        GDocument document = this.activeDocument instanceof GSolution ? this.masterSolution : this.activeDocument;
        String filePath = document instanceof GProblem ? this.problemPath : this.solutionPath;
        StringBuffer buf = new StringBuffer();
        document.serialize(buf, true);
        FileFilter[] fileFilters = new FileFilter[]{};
        GFileWriter writer = this.getFileWriter(this.getOwnerFrame(), filePath, fileFilters, true);
        try {
            int option;
            writer.selectFile();
            if (!writer.approved()) {
                return false;
            }
            if (writer.fileExists() && (option = GGraphicsFactory.getInstance().showYesNoDialog(GDictionary.get("FileExistsOverwrite", new String[0]))) != 0) {
                return false;
            }
            writer.write(String.valueOf(buf));
        }
        catch (Exception exception) {
            this.error(exception);
            return false;
        }
        filePath = writer.getSelectedFilePath();
        if (document instanceof GProblem) {
            this.problemPath = filePath;
        } else {
            this.solutionPath = filePath;
        }
        document.setPrime(false);
        String fileName = new File(filePath).getName();
        this.setTitle(fileName);
        this.setDocumentModified(false);
        logger.info((Object)filePath);
        return true;
    }

    public GFigure newFigure(GSolid solid, double zoomFactor) {
        logger.info((Object)solid);
        GFigure figure = new GFigure(solid, zoomFactor);
        List<String> figureNames = this.activeDocument.getFigureNames();
        String name = GLabelFactory.getInstance().newFigureName(figureNames);
        figure.setName(name);
        this.activeDocument.addFigure(figure);
        this.activeDocument.setSelectedFigure(name);
        this.addFigure(figure);
        return figure;
    }

    public GFigure newFigure(GSolid solid) {
        return this.newFigure(solid, 1.0);
    }

    public void addFigure(GFigure figure, int index) {
        logger.info((Object)(figure.getName() + ", " + index));
        this.mainPanel.addFigure(figure, index);
    }

    public void addFigure(GFigure figure) {
        logger.info((Object)figure.getName());
        this.mainPanel.addFigure(figure);
    }

    public void removeFigure(String figureName) {
        logger.info((Object)figureName);
        this.mainPanel.removeFigure(figureName);
    }

    public void renameFigure(String oldName, String newName) {
        logger.info((Object)(oldName + ", " + newName));
        this.mainPanel.renameFigure(oldName, newName);
    }

    public void clearUndoableActions() {
        logger.info((Object)"");
        this.actions.clear();
        this.actionIndex = -1;
    }

    public AbstractAction getActionHandler(String name) {
        return this.actionHandlers.get(name);
    }

    public void addAction(GUndoable action) {
        for (int i = this.actions.size() - 1; i > this.actionIndex; --i) {
            this.actions.remove(i);
        }
        this.actions.add(action);
        ++this.actionIndex;
    }

    public GUndoable getCurrentAction() {
        return this.actions.get(this.actionIndex);
    }

    public void toPreviousAction() {
        --this.actionIndex;
    }

    public GUndoable toNextAction() {
        return this.actions.get(++this.actionIndex);
    }

    private GUndoable getNextAction() {
        return this.actions.get(this.actionIndex + 1);
    }

    public boolean hasNextAction() {
        return this.actionIndex < this.actions.size() - 1;
    }

    public void removeLoggableFollowing(GLoggable action) {
        logger.info((Object)action);
        int index = this.actions.indexOf(action);
        for (int i = this.actions.size() - 1; i > index; --i) {
            GUndoable a = this.actions.get(i);
            if (!(a instanceof GLoggable)) continue;
            this.actions.remove(i);
        }
        this.actionIndex = this.actions.size() - 1;
    }

    public void exit() {
        logger.info((Object)"");
        this.container.exit();
    }

    public void handleEvent(EventObject event) {
        logger.info(event.getSource());
        if (event instanceof GDocumentModifiedEvent) {
            this.updateActionHandlerStates();
        }
    }

    public void error(Exception exception) {
        this.error(exception.getMessage());
    }

    public void error(String message) {
        GGraphicsFactory.getInstance().showErrorDialog(message);
    }

    public void setContainer(GContainer container) {
        this.container = container;
        this.setTitle(null);
    }

    public GDocument getActiveDocument() {
        return this.activeDocument;
    }

    public void setActiveDocument(GDocument document) {
        logger.info((Object)"");
        this.activeDocument = document;
    }

    public GSolution getMasterSolution() {
        return this.masterSolution;
    }

    public void setMasterSolution(GSolution document) {
        logger.info((Object)"");
        this.masterSolution = document;
    }

    public Frame getOwnerFrame() {
        return this.container.getOwnerFrame();
    }

    public String getProblemPath() {
        return this.problemPath;
    }

    public String getSolutionPath() {
        return this.solutionPath;
    }

    public String getFigurePath() {
        return this.figurePath;
    }

    public void setProblemPath(String filePath) {
        logger.info((Object)filePath);
        this.problemPath = filePath;
    }

    public void setSolutionPath(String filePath) {
        logger.info((Object)filePath);
        this.solutionPath = filePath;
    }

    public void setFigurePath(String filePath) {
        logger.info((Object)filePath);
        this.figurePath = filePath;
    }

    public GFileReader getFileReader(Frame ownerFrame, String filePath, FileFilter[] filters, boolean acceptAllFileFilter) {
        return this.container.getFileReader(ownerFrame, filePath, filters, acceptAllFileFilter);
    }

    public GFileWriter getFileWriter(Frame ownerFrame, String filePath, FileFilter[] filters, boolean acceptAllFileFilter) {
        return this.container.getFileWriter(ownerFrame, filePath, filters, acceptAllFileFilter);
    }

    public void documentChanged() {
        logger.info((Object)"");
        this.mainPanel.documentChanged(this.activeDocument);
    }

    public void figureSelectionChanged() {
        logger.info((Object)"");
        this.mainPanel.figureSelectionChanged();
    }

    public void setTitle(String title) {
        this.title = title;
        this.updateTitleBar();
    }

    private void updateTitleBar() {
        if (!(this.container instanceof GFrame)) {
            return;
        }
        String barTitle = GVersionManager.getInstance().getApplicationName();
        if (this.title != null) {
            barTitle = this.title + " - " + barTitle;
            if (this.documentModified && !this.title.startsWith("*")) {
                barTitle = "*" + barTitle;
            }
        }
        this.getOwnerFrame().setTitle(barTitle);
    }

    public void notepadChanged() {
        logger.info((Object)"");
        this.mainPanel.notepadChanged(this.activeDocument);
    }

    public boolean isSelectorOn() {
        return this.selectorOn;
    }

    public void setSelectorOn(boolean selectorOn) {
        logger.info((Object)selectorOn);
        this.selectorOn = selectorOn;
    }

    public GCalculator getCalculator() {
        return this.calculator;
    }

    public void setMainPanel(GMainPanel mainPanel) {
        logger.info((Object)"");
        this.mainPanel = mainPanel;
    }

    public void setDocumentModified(boolean modified) {
        this.documentModified = modified;
        this.updateTitleBar();
    }

    public boolean getDocumentModified() {
        return this.documentModified;
    }

    public void updateSaveActionHandlerState(boolean enabled) {
        this.getActionHandler("document.saveDocument").setEnabled(enabled);
    }

    public void languageChanged() throws Exception {
        this.container.load();
        this.setTitle(null);
    }

    public void fontChanged() throws Exception {
        this.container.load();
    }

    static {
        logger = Logger.getLogger((String)"net.geocentral.geometria");
    }
}

