/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GDivideLineDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDivideLineAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    protected String figureName;
    protected String numeratorString;
    protected String denominatorString;
    protected String p1Label;
    protected String p2Label;
    protected GDocument document;
    protected String addedPointLabel;
    private GFigure figure;
    private GSolid solid;
    private String comments;
    private String helpId;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        this.document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            GSolid solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            GDivideLineDialog dialog = new GDivideLineDialog(documentHandler.getOwnerFrame(), this, true);
            dialog.prefill(this.p1Label, this.p2Label, null, null);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            solid.clearSelection();
        }
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.p1Label + ", " + this.p2Label + ", " + this.numeratorString + ", " + this.denominatorString));
        return true;
    }

    protected void prefill(Set<GSelectable> selection) {
        GSelectable element;
        logger.info(selection);
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 1 && (element = it.next()) instanceof GStick) {
            this.p1Label = ((GStick)element).label1;
            this.p2Label = ((GStick)element).label2;
        }
        if (selection.size() == 2) {
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GPoint3d) {
                this.p1Label = ((GPoint3d)element1).getLabel();
                this.p2Label = ((GPoint3d)element2).getLabel();
            }
        }
    }

    public void validateApply() throws Exception {
        Double denominator;
        Double numerator;
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        if (this.numeratorString.length() == 0) {
            logger.info((Object)"No numerator");
            throw new Exception(GDictionary.get("EnterValidExpressionForNumerator", new String[0]));
        }
        GNotepadVariable variable = this.document.getVariable(this.numeratorString);
        if (variable != null) {
            numerator = variable.getValue();
        } else {
            List<GNotepadVariable> variables = this.document.getNotepad().getVariables();
            numerator = GMath.evaluate(this.numeratorString, variables);
            if (numerator == null) {
                logger.info((Object)("Bad numerator: " + this.numeratorString));
                throw new Exception(GDictionary.get("EnterValidExpressionForNumerator", new String[0]));
            }
        }
        if (numerator <= 0.0) {
            logger.info((Object)("Numerator must be positive: " + numerator));
            throw new Exception(GDictionary.get("NumeratorMustBePositive", new String[0]));
        }
        if (this.denominatorString.length() == 0) {
            logger.info((Object)"No denominator");
            throw new Exception(GDictionary.get("EnterValidExpressionForDenominator", new String[0]));
        }
        variable = this.document.getVariable(this.denominatorString);
        if (variable != null) {
            denominator = variable.getValue();
        } else {
            List<GNotepadVariable> variables = this.document.getNotepad().getVariables();
            denominator = GMath.evaluate(this.denominatorString, variables);
            if (denominator == null) {
                logger.info((Object)("Bad denominator: " + this.denominatorString));
                throw new Exception(GDictionary.get("EnterValidExpressionForDenominator", new String[0]));
            }
        }
        if (denominator <= 0.0) {
            logger.info((Object)("Denominator must be positive: " + denominator));
            throw new Exception(GDictionary.get("DenominatorMustBePositive", new String[0]));
        }
        if (this.p1Label.length() == 0 || this.p2Label.length() == 0) {
            logger.info((Object)("No end points: " + this.p1Label + ", " + this.p2Label));
            throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
        }
        GPoint3d p1 = this.solid.getPoint(this.p1Label);
        if (p1 == null) {
            logger.info((Object)("No point: " + this.p1Label));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.p1Label));
        }
        GPoint3d p2 = this.solid.getPoint(this.p2Label);
        if (p2 == null) {
            logger.info((Object)("No point: " + this.p2Label));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.p2Label));
        }
        if (p1 == p2) {
            logger.info((Object)("Equal end points: " + this.p1Label + ", " + this.p2Label));
            throw new Exception(GDictionary.get("EndPointsCannotBeEqual", new String[0]));
        }
        Point3d pCoords = new Point3d();
        Point3d scaledP1Coords = new Point3d();
        scaledP1Coords.scale(denominator.doubleValue(), (Tuple3d)p1.coords);
        Point3d scaledP2Coords = new Point3d();
        scaledP2Coords.scale(numerator.doubleValue(), (Tuple3d)p2.coords);
        pCoords.add((Tuple3d)scaledP1Coords, (Tuple3d)scaledP2Coords);
        pCoords.scale(1.0 / (numerator + denominator));
        GPoint3d p = this.solid.getPoint(pCoords);
        if (p != null) {
            logger.info((Object)"Already divided");
            throw new Exception(GDictionary.get("LineAlreadyDividedInRatio", this.p1Label + this.p2Label, this.numeratorString, this.denominatorString, this.figureName));
        }
        Collection<GLine> lines = this.solid.linesThroughPoints(this.p1Label, this.p2Label);
        if (lines.isEmpty()) {
            logger.info((Object)("No line: " + this.p1Label + ", " + this.p2Label));
            throw new Exception(GDictionary.get("NoLinePassesThroughPoints", this.p1Label, this.p2Label, this.figureName));
        }
        GPoint3d divPoint = this.solid.addPoint(pCoords);
        this.addedPointLabel = divPoint.getLabel();
        Collection<GFace> faces = this.solid.facesThroughPoints(new String[]{this.p1Label, this.p2Label});
        for (GFace face : faces) {
            face.addPoint(divPoint, this.solid);
        }
        this.solid.makeConfig();
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        GPoint3d p = this.solid.getPoint(this.addedPointLabel);
        Collection<GFace> faces = this.solid.facesThroughPoints(new String[]{this.p1Label, this.p2Label});
        for (GFace face : faces) {
            face.removePoint(p);
        }
        this.solid.removePoint(this.addedPointLabel);
        this.solid.makeConfig();
        this.figure.repaint();
        this.document.setSelectedFigure(this.figureName);
        logger.info((Object)("Divide line " + this.p1Label + this.p2Label + " undone"));
    }

    @Override
    public GLoggable clone() {
        GDivideLineAction action = new GDivideLineAction();
        action.figureName = this.figureName;
        action.numeratorString = this.numeratorString;
        action.denominatorString = this.denominatorString;
        action.p1Label = this.p1Label;
        action.p2Label = this.p2Label;
        action.addedPointLabel = this.addedPointLabel;
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("DivideLineInRatio", this.p1Label + this.p2Label, this.numeratorString, this.denominatorString, this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("numerator");
        if (ns.getLength() == 0) {
            logger.error((Object)"No numerator");
            throw new Exception();
        }
        this.numeratorString = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("denominator");
        if (ns.getLength() == 0) {
            logger.error((Object)"No denominator");
            throw new Exception();
        }
        this.denominatorString = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.p1Label = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.p2Label = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<numerator>").append(this.numeratorString).append("</numerator>").append("\n<denominator>").append(this.denominatorString).append("</denominator>").append("\n<p1Label>").append(this.p1Label).append("</p1Label>").append("\n<p2Label>").append(this.p2Label).append("</p2Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p1String, String p2String, String numeratorString, String denominatorString) {
        logger.info((Object)(p1String + ", " + p2String + ", " + numeratorString + ", " + denominatorString));
        this.p1Label = p1String.toUpperCase();
        this.p2Label = p2String.toUpperCase();
        this.numeratorString = numeratorString;
        this.denominatorString = denominatorString;
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("divideLineInRatio", this.p1Label + this.p2Label, this.numeratorString, this.denominatorString);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

