/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GDivideAngleDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDivideAngleAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    protected String figureName;
    protected String numeratorString;
    protected String denominatorString;
    protected String[] pLabels;
    protected GDocument document;
    private GFigure figure;
    private GSolid solid;
    private GFace face;
    private GPoint3d addedPoint;
    private GLine addedLine;
    private List<GLine> removedLines;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        this.document = documentHandler.getActiveDocument();
        if (silent) {
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            GSolid solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            GDivideAngleDialog dialog = new GDivideAngleDialog(documentHandler.getOwnerFrame(), this, true);
            dialog.prefill(this.pLabels[0], this.pLabels[1], this.pLabels[2], null, null);
            dialog.setVisible(true);
            if (!dialog.getResult()) {
                return false;
            }
            solid.clearSelection();
        }
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + Arrays.asList(this.pLabels) + ", " + this.numeratorString + ", " + this.denominatorString));
        return true;
    }

    protected void prefill(Set<GSelectable> selection) {
        logger.info(selection);
        this.pLabels = new String[3];
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 2) {
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GStick && element2 instanceof GStick) {
                if (((GStick)element1).label1.equals(((GStick)element2).label1)) {
                    this.pLabels[0] = ((GStick)element1).label1;
                    this.pLabels[1] = ((GStick)element1).label2;
                    this.pLabels[2] = ((GStick)element2).label2;
                } else if (((GStick)element1).label1.equals(((GStick)element2).label2)) {
                    this.pLabels[0] = ((GStick)element1).label1;
                    this.pLabels[1] = ((GStick)element1).label2;
                    this.pLabels[2] = ((GStick)element2).label1;
                } else if (((GStick)element1).label2.equals(((GStick)element2).label1)) {
                    this.pLabels[0] = ((GStick)element1).label2;
                    this.pLabels[1] = ((GStick)element1).label1;
                    this.pLabels[2] = ((GStick)element2).label2;
                } else if (((GStick)element1).label2.equals(((GStick)element2).label2)) {
                    this.pLabels[0] = ((GStick)element1).label2;
                    this.pLabels[1] = ((GStick)element1).label1;
                    this.pLabels[2] = ((GStick)element2).label1;
                }
            }
        }
    }

    public void validateApply() throws Exception {
        GLine line3;
        Double denominator;
        Double numerator;
        logger.info((Object)"");
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        if (this.numeratorString.length() == 0) {
            logger.info((Object)"No numerator");
            throw new Exception(GDictionary.get("EnterValidExpressionForNumerator", new String[0]));
        }
        GNotepadVariable variable = this.document.getVariable(this.numeratorString);
        if (variable != null) {
            numerator = variable.getValue();
        } else {
            List<GNotepadVariable> variables = this.document.getNotepad().getVariables();
            numerator = GMath.evaluate(this.numeratorString, variables);
            if (numerator == null) {
                logger.info((Object)("Bad numerator: " + this.numeratorString));
                throw new Exception(GDictionary.get("EnterValidExpressionForNumerator", new String[0]));
            }
        }
        if (numerator <= 0.0) {
            logger.info((Object)("Numerator must be positive: " + numerator));
            throw new Exception(GDictionary.get("NumeratorMustBePositive", new String[0]));
        }
        if (this.denominatorString.length() == 0) {
            logger.info((Object)"No denominator");
            throw new Exception(GDictionary.get("EnterValidExpressionForDenominator", new String[0]));
        }
        variable = this.document.getVariable(this.denominatorString);
        if (variable != null) {
            denominator = variable.getValue();
        } else {
            List<GNotepadVariable> variables = this.document.getNotepad().getVariables();
            denominator = GMath.evaluate(this.denominatorString, variables);
            if (denominator == null) {
                logger.info((Object)("Bad denominator: " + this.denominatorString));
                throw new Exception(GDictionary.get("EnterValidExpressionForDenominator", new String[0]));
            }
        }
        if (denominator <= 0.0) {
            logger.info((Object)("Denominator must be positive: " + denominator));
            throw new Exception(GDictionary.get("DenominatorMustBePositive", new String[0]));
        }
        GPoint3d[] ps = new GPoint3d[3];
        for (int i = 0; i < 3; ++i) {
            if (this.pLabels[i].length() == 0) {
                logger.info((Object)("No end points: " + Arrays.asList(this.pLabels)));
                throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
            }
            ps[i] = this.solid.getPoint(this.pLabels[i]);
            if (ps[i] != null) continue;
            logger.info((Object)("No point: " + this.pLabels[i]));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.pLabels[i]));
        }
        if (ps[0] == ps[1] || ps[0] == ps[2]) {
            logger.info((Object)("Equal end points: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
        }
        Collection<GFace> faces = this.solid.facesThroughPoints(this.pLabels);
        if (faces.isEmpty()) {
            logger.info((Object)("No face: " + Arrays.asList(this.pLabels)));
            throw new Exception(GDictionary.get("LinesDoNotBelongToSameFace", this.pLabels[0] + this.pLabels[1], this.pLabels[0] + this.pLabels[2], this.figureName));
        }
        this.face = faces.iterator().next();
        GLine line1 = this.face.lineThroughPoints(this.pLabels[0], this.pLabels[1]);
        if (line1 == null) {
            logger.info((Object)("No line: " + this.pLabels[0] + ", " + this.pLabels[1]));
            throw new Exception(GDictionary.get("NoLinePassesThroughPoints", this.pLabels[0], this.pLabels[1], this.figureName));
        }
        GLine line2 = this.face.lineThroughPoints(this.pLabels[0], this.pLabels[2]);
        if (line2 == null) {
            logger.info((Object)("No line: " + this.pLabels[0] + ", " + this.pLabels[2]));
            throw new Exception(GDictionary.get("NoLinePassesThroughPoints", this.pLabels[0], this.pLabels[2], this.figureName));
        }
        if (line1 == line2) {
            logger.info((Object)("No angle: " + line1 + ", " + line2));
            throw new Exception(GDictionary.get("LinesDoNotMakeAngle", this.pLabels[0] + this.pLabels[1], this.pLabels[0] + this.pLabels[2], this.figureName));
        }
        Vector3d v = GMath.divideAngle(ps[0].coords, ps[1].coords, ps[2].coords, numerator / denominator);
        List<GLine> lines = this.face.linesThroughPoint(this.pLabels[0]);
        for (GLine line3 : lines) {
            Vector3d v1 = new Vector3d((Tuple3d)this.solid.getPoint((String)line3.firstLabel()).coords);
            v1.sub((Tuple3d)ps[0].coords);
            Vector3d v2 = new Vector3d((Tuple3d)this.solid.getPoint((String)line3.lastLabel()).coords);
            v2.sub((Tuple3d)ps[0].coords);
            double epsilon = this.solid.getEpsilon();
            if ((line3.firstLabel().equals(this.pLabels[0]) || !GMath.areCooriented(v1, v, epsilon)) && (line3.lastLabel().equals(this.pLabels[0]) || !GMath.areCooriented(v2, v, epsilon))) continue;
            logger.info((Object)"Already divided");
            throw new Exception(GDictionary.get("AngleAlreadyDivided", this.pLabels[1] + this.pLabels[0] + this.pLabels[2], this.numeratorString, this.denominatorString, this.figureName));
        }
        Object[] result = this.face.intersectRay(ps[0].coords, v, this.solid);
        line3 = (GLine)result[0];
        Point3d pCoords = (Point3d)result[1];
        GPoint3d p = this.solid.getPoint(pCoords);
        if (p == null) {
            p = this.solid.addPoint(pCoords);
            GFace f = line3.getFace();
            f.addPoint(p, this.solid);
            f = line3.getTwin().getFace();
            f.addPoint(p, this.solid);
            this.addedPoint = p;
        }
        this.removedLines = new ArrayList<GLine>();
        this.addedLine = this.face.addLine(ps[0], p, this.removedLines, this.solid);
        this.solid.makeConfig();
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        if (this.addedPoint != null) {
            Collection<GFace> faces = this.solid.facesThroughPoint(this.addedPoint.getLabel());
            for (GFace face : faces) {
                face.removePoint(this.addedPoint);
            }
            this.solid.removePoint(this.addedPoint.getLabel());
        }
        this.face.undoAddLine(this.addedLine, this.removedLines);
        this.solid.makeConfig();
        this.figure.repaint();
        this.document.setSelectedFigure(this.figureName);
        logger.info((Object)(this.figureName + ", " + Arrays.asList(this.pLabels) + ", " + this.numeratorString + ", " + this.denominatorString));
    }

    @Override
    public GLoggable clone() {
        GDivideAngleAction action = new GDivideAngleAction();
        action.figureName = this.figureName;
        action.numeratorString = this.numeratorString;
        action.denominatorString = this.denominatorString;
        action.pLabels = new String[3];
        for (int i = 0; i < 3; ++i) {
            action.pLabels[i] = this.pLabels[i];
        }
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("DivideAngleInRatio", this.pLabels[1] + this.pLabels[0] + this.pLabels[2], this.numeratorString, this.denominatorString, this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("numerator");
        if (ns.getLength() == 0) {
            logger.error((Object)"No numerator");
            throw new Exception();
        }
        this.numeratorString = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("denominator");
        if (ns.getLength() == 0) {
            logger.error((Object)"No denominator");
            throw new Exception();
        }
        this.denominatorString = ns.item(0).getTextContent();
        this.pLabels = new String[3];
        ns = node.getElementsByTagName("p0Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p0Label");
            throw new Exception();
        }
        this.pLabels[0] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.pLabels[1] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.pLabels[2] = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<numerator>").append(this.numeratorString).append("</numerator>").append("\n<denominator>").append(this.denominatorString).append("</denominator>").append("\n<p0Label>").append(this.pLabels[0]).append("</p0Label>").append("\n<p1Label>").append(this.pLabels[1]).append("</p1Label>").append("\n<p2Label>").append(this.pLabels[2]).append("</p2Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p0String, String p1String, String p2String, String numeratorString, String denominatorString) {
        logger.info((Object)(p0String + ", " + p1String + ", " + p2String + ", " + numeratorString + ", " + denominatorString));
        this.pLabels[0] = p0String.toUpperCase();
        this.pLabels[1] = p1String.toUpperCase();
        this.pLabels[2] = p2String.toUpperCase();
        this.numeratorString = numeratorString;
        this.denominatorString = denominatorString;
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("divideAngleInRatio", this.pLabels[1] + this.pLabels[0] + this.pLabels[2], this.numeratorString, this.denominatorString);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

