/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.List;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLabelFactory;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GCloneFigureAction
implements GLoggable,
GFigureAction {
    private String figureName;
    private String cloneName;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GDocument document = documentHandler.getActiveDocument();
        GFigure figure = document.getSelectedFigure();
        this.figureName = figure.getName();
        logger.info((Object)this.figureName);
        GFigure clonedFigure = figure.clone();
        List<String> figureNames = document.getFigureNames();
        this.cloneName = GLabelFactory.getInstance().newFigureName(figureNames);
        clonedFigure.setName(this.cloneName);
        document.addFigure(clonedFigure);
        documentHandler.addFigure(clonedFigure);
        document.setSelectedFigure(this.cloneName);
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        documentHandler.notepadChanged();
        logger.info((Object)this.cloneName);
        return true;
    }

    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        document.removeFigure(this.cloneName);
        documentHandler.removeFigure(this.cloneName);
        documentHandler.notepadChanged();
        logger.info((Object)this.cloneName);
    }

    public GLoggable clone() {
        GCloneFigureAction action = new GCloneFigureAction();
        action.figureName = this.figureName;
        action.cloneName = this.cloneName;
        return action;
    }

    public String toLogString() {
        return GDictionary.get("CloneFigure", this.figureName, this.cloneName);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>");
        buf.append("\n<className>");
        buf.append(this.getClass().getSimpleName());
        buf.append("</className>");
        buf.append("\n<figureName>");
        buf.append(this.figureName);
        buf.append("</figureName>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public String getShortDescription() {
        return GDictionary.get("cloneFigure", this.figureName);
    }

    public String getFigureName() {
        return this.figureName;
    }
}

