/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.List;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GCalculation;
import net.geocentral.geometria.model.GCalculator;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GNotepad;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GGraphicsFactory;
import net.geocentral.geometria.util.GMath;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GCalcEvaluateAction
implements GLoggable {
    private String variableName;
    private String expression;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public boolean execute() {
        return this.execute(false);
    }

    public boolean execute(boolean silent) {
        GNotepadRecord record;
        logger.info((Object)silent);
        GDocumentHandler documentHandler = GDocumentHandler.getInstance();
        GCalculator calculator = documentHandler.getCalculator();
        GDocument document = documentHandler.getActiveDocument();
        if (silent) {
            Double value;
            List<GNotepadVariable> variables = document.getNotepad().getVariables();
            try {
                value = GMath.evaluate(this.expression, variables);
            }
            catch (Exception exception) {
                return false;
            }
            GCalculation calculation = new GCalculation(this.expression);
            GNotepadVariable variable = new GNotepadVariable(this.variableName, value);
            record = new GNotepadRecord(variable, calculation);
        } else {
            if (calculator.isEmpty()) {
                return false;
            }
            try {
                record = calculator.evaluate(document);
            }
            catch (Exception exception) {
                GGraphicsFactory.getInstance().showErrorDialog(exception.getMessage());
                return false;
            }
            if (record == null) {
                return false;
            }
        }
        GNotepad notepad = document.getNotepad();
        notepad.add(record);
        this.variableName = record.getVariable().getName();
        this.expression = record.getExpression();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)record);
        return true;
    }

    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        GDocument document = documentHandler.getActiveDocument();
        GNotepad notepad = document.getNotepad();
        notepad.removeLastRecord();
    }

    public GLoggable clone() {
        GCalcEvaluateAction action = new GCalcEvaluateAction();
        action.variableName = this.variableName;
        action.expression = this.expression;
        return action;
    }

    public String getShortDescription() {
        return "calculate " + this.variableName + "=" + this.expression;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String toLogString() {
        StringBuffer buf = new StringBuffer();
        buf.append(GDictionary.get("Calculate", this.variableName, this.expression));
        return String.valueOf(buf);
    }

    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("variableName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No variable name");
            throw new Exception();
        }
        this.variableName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("expression");
        if (ns.getLength() == 0) {
            logger.error((Object)"No expression");
            throw new Exception();
        }
        this.expression = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<variableName>").append(this.variableName).append("</variableName>").append("\n<expression>").append(this.expression).append("</expression>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }
}

