/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PrefsPane
extends JFrame {
    zone Z;
    protected TableColor table = new TableColor(12, 5, 10, 10);
    protected String fontName;
    protected int fontSize = 12;
    protected Font titleFont;
    protected Font bodyFont;
    JLabel lbg;
    JLabel lbd;
    JLabel lbb;
    JLabel lbh;
    JLabel lbx;
    JLabel lby;
    JLabel lbu;
    JLabel lbv;
    JLabel lbz;
    JLabel lbt;
    String[] lab = dessin.extract("prefslab");
    JLabel[] LB;
    final JTextField tfg;
    final JTextField tfd;
    final JTextField tfb;
    final JTextField tfh;
    final JTextField tfx;
    final JTextField tfy;
    final JTextField tfu;
    final JTextField tfv;
    final JTextField tfz;
    final JTextField tft;
    JTextField[] TF;
    JCheckBox checkRep;
    JCheckBox checkQuad;
    JCheckBox[] CK;
    JRadioButton brep;
    JRadioButton bqua;
    JRadioButton bcac;
    JRadioButton[] RB;
    ButtonGroup group;
    String[] fontNames;
    String[] fontSizes;
    String[] str;
    JComboBox comboFont;
    JComboBox comboSize;
    JComboBox[] CB;
    MouseListener buttonListener;
    ActionListener coordListener;
    ActionListener unitListener;
    ActionListener gridListener;
    ActionListener roundListener;
    ItemListener radioListener;
    ItemListener comboListener;
    WindowAdapter windowListener;

    int getIndex(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public PrefsPane(zone zone2) {
        int n;
        this.lbg = new JLabel(this.lab[0]);
        this.lbd = new JLabel(this.lab[1]);
        this.lbb = new JLabel(this.lab[2]);
        this.lbh = new JLabel(this.lab[3]);
        this.lbx = new JLabel(this.lab[4]);
        this.lby = new JLabel(this.lab[5]);
        this.lbu = new JLabel(this.lab[6]);
        this.lbv = new JLabel(this.lab[7]);
        this.lbz = new JLabel(this.lab[8]);
        this.lbt = new JLabel(this.lab[9]);
        this.LB = new JLabel[]{this.lbg, this.lbd, this.lbb, this.lbh, this.lbx, this.lby, this.lbu, this.lbv, this.lbz, this.lbt};
        this.tfg = new JTextField(4);
        this.tfd = new JTextField(4);
        this.tfb = new JTextField(4);
        this.tfh = new JTextField(4);
        this.tfx = new JTextField(4);
        this.tfy = new JTextField(4);
        this.tfu = new JTextField(4);
        this.tfv = new JTextField(4);
        this.tfz = new JTextField(4);
        this.tft = new JTextField(4);
        this.TF = new JTextField[]{this.tfg, this.tfd, this.tfb, this.tfh, this.tfx, this.tfy, this.tfu, this.tfv, this.tfz, this.tft};
        this.group = new ButtonGroup();
        this.fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(dessin.LOCALE);
        this.fontSizes = new String[]{"", "8", "9", "10", "11", "12", "14", "16", "18", "24", "32", "48"};
        this.str = dessin.extract("prefspane");
        this.comboFont = new JComboBox<String>(this.fontNames);
        this.comboSize = new JComboBox<String>(this.fontSizes);
        this.CB = new JComboBox[]{this.comboFont, this.comboSize};
        this.buttonListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                boolean bl = mouseEvent.isShiftDown() ? dessin.parseUnits(new String[]{PrefsPane.this.TF[4].getText(), PrefsPane.this.TF[5].getText()}) : dessin.parseCoords(new String[]{PrefsPane.this.TF[0].getText(), PrefsPane.this.TF[1].getText(), PrefsPane.this.TF[2].getText(), PrefsPane.this.TF[3].getText()});
                bl = bl || dessin.parseGrid(new String[]{PrefsPane.this.TF[6].getText(), PrefsPane.this.TF[7].getText()});
                boolean bl2 = bl = bl || dessin.parseRound(new String[]{PrefsPane.this.TF[8].getText(), PrefsPane.this.TF[9].getText()});
                if (bl) {
                    dessin.setOrigin();
                    PrefsPane.this.refresh();
                    PrefsPane.this.Z.D.refresh();
                }
            }
        };
        this.coordListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dessin.parseCoords(new String[]{PrefsPane.this.TF[0].getText(), PrefsPane.this.TF[1].getText(), PrefsPane.this.TF[2].getText(), PrefsPane.this.TF[3].getText()})) {
                    dessin.setOrigin();
                }
            }
        };
        this.unitListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dessin.parseUnits(new String[]{PrefsPane.this.TF[4].getText(), PrefsPane.this.TF[5].getText()})) {
                    dessin.setOrigin();
                }
            }
        };
        this.gridListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dessin.parseGrid(new String[]{PrefsPane.this.TF[6].getText(), PrefsPane.this.TF[7].getText()})) {
                    dessin.setOrigin();
                }
            }
        };
        this.roundListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dessin.parseRound(new String[]{PrefsPane.this.TF[8].getText(), PrefsPane.this.TF[9].getText()})) {
                    PrefsPane.this.refresh();
                    PrefsPane.this.Z.D.refresh();
                }
            }
        };
        this.radioListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if ((PrefsPane.this.brep.isSelected() || PrefsPane.this.bqua.isSelected()) && !PrefsPane.this.table.isVisible()) {
                    PrefsPane.this.table.setVisible(true);
                    PrefsPane.this.pack();
                } else if (PrefsPane.this.bcac.isSelected() && PrefsPane.this.table.isVisible()) {
                    PrefsPane.this.table.setVisible(false);
                    PrefsPane.this.pack();
                }
            }
        };
        this.comboListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                if (jComboBox == PrefsPane.this.comboFont) {
                    PrefsPane.this.fontName = (String)jComboBox.getSelectedItem();
                } else if (jComboBox == PrefsPane.this.comboSize) {
                    try {
                        PrefsPane.this.fontSize = Integer.parseInt((String)jComboBox.getSelectedItem());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                dessin.setFont(new Font(PrefsPane.this.fontName, 0, PrefsPane.this.fontSize));
                if (PrefsPane.this.Z == null) {
                    return;
                }
                PrefsPane.this.Z.A.changeFont(dessin.FONT_PLAIN);
                PrefsPane.this.Z.D.changeFont(dessin.FONT_PLAIN);
                int n = 0;
                while (true) {
                    zone cfr_ignored_0 = PrefsPane.this.Z;
                    if (n >= zone.GR.size()) break;
                    zone cfr_ignored_1 = PrefsPane.this.Z;
                    objetG objetG2 = (objetG)zone.GR.elementAt(n);
                    objetG2.changeFont();
                    ++n;
                }
                PrefsPane.this.Z.repaint();
            }
        };
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                Point point2 = PrefsPane.this.Z.getLocation();
                PrefsPane.this.setLocation(point2.x + PrefsPane.this.Z.getWidth(), point2.y + (PrefsPane.this.Z.A.isVisible() ? PrefsPane.this.Z.A.getHeight() + PrefsPane.this.getInsets().top : 0));
            }
        };
        this.Z = zone2;
        this.addWindowListener(this.windowListener);
        this.brep = new JRadioButton(this.str[0]);
        this.bqua = new JRadioButton(this.str[1]);
        this.bcac = new JRadioButton(this.str[2]);
        this.RB = new JRadioButton[]{this.brep, this.bqua, this.bcac};
        this.checkRep = new JCheckBox(this.Z.repAction);
        this.checkQuad = new JCheckBox(this.Z.quadAction);
        this.CK = new JCheckBox[]{this.checkRep, this.checkQuad};
        this.titleFont = new Font("Lucida Sans", 1, 14);
        this.bodyFont = new Font("Lucida Sans", 0, 12);
        this.fontName = this.bodyFont.getName();
        for (n = 0; n < this.LB.length; ++n) {
            this.LB[n].setFont(this.bodyFont);
        }
        for (n = 0; n < this.TF.length; ++n) {
            this.TF[n].setFont(this.bodyFont);
            if (n < 4) {
                this.TF[n].addActionListener(this.coordListener);
            } else if (n < 6) {
                this.TF[n].addActionListener(this.unitListener);
            } else if (n < 8) {
                this.TF[n].addActionListener(this.gridListener);
            } else {
                this.TF[n].addActionListener(this.roundListener);
            }
            this.TF[n].setHorizontalAlignment(2);
        }
        for (n = 0; n < this.CB.length; ++n) {
            this.CB[n].setFont(this.bodyFont);
            this.CB[n].addItemListener(this.comboListener);
        }
        for (n = 0; n < this.CK.length; ++n) {
            this.CK[n].setFont(this.bodyFont);
        }
        for (n = 0; n < this.RB.length; ++n) {
            this.RB[n].setFont(this.bodyFont);
            this.RB[n].addItemListener(this.radioListener);
            this.group.add(this.RB[n]);
        }
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        FlowLayout flowLayout = new FlowLayout(0);
        this.setTitle(this.str[3]);
        Panel panel = new Panel(flowLayout);
        container.add(panel);
        JLabel jLabel = new JLabel(this.str[4]);
        panel.add(jLabel);
        jLabel.setFont(this.bodyFont);
        panel = new Panel();
        container.add(panel);
        panel.add(this.lbg);
        panel.add(this.tfg);
        panel.add(Box.createHorizontalStrut(15));
        panel.add(this.lbd);
        panel.add(this.tfd);
        panel = new Panel();
        container.add(panel);
        panel.add(this.lbb);
        panel.add(this.tfb);
        panel.add(Box.createHorizontalStrut(15));
        panel.add(this.lbh);
        panel.add(this.tfh);
        panel = new Panel(flowLayout);
        container.add(panel);
        jLabel = new JLabel(this.str[5]);
        panel.add(jLabel);
        jLabel.setFont(this.bodyFont);
        panel = new Panel();
        container.add(panel);
        panel.add(Box.createHorizontalStrut(20));
        panel.add(this.checkRep);
        this.checkRep.setSelected(zone.repereVisible);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.checkQuad);
        this.checkQuad.setSelected(zone.quadrillageVisible);
        panel = new Panel(flowLayout);
        container.add(panel);
        jLabel = new JLabel(this.str[6]);
        panel.add(jLabel);
        jLabel.setFont(this.bodyFont);
        panel = new Panel();
        container.add(panel);
        panel.add(this.lbx);
        panel.add(this.tfx);
        panel.add(Box.createHorizontalStrut(15));
        panel.add(this.lby);
        panel.add(this.tfy);
        panel = new Panel(flowLayout);
        container.add(panel);
        jLabel = new JLabel(this.str[7]);
        panel.add(jLabel);
        jLabel.setFont(this.bodyFont);
        panel = new Panel();
        container.add(panel);
        panel.add(this.lbu);
        panel.add(this.tfu);
        panel.add(Box.createHorizontalStrut(15));
        panel.add(this.lbv);
        panel.add(this.tfv);
        panel = new Panel(flowLayout);
        container.add(panel);
        jLabel = new JLabel(this.str[8]);
        panel.add(jLabel);
        jLabel.setFont(this.bodyFont);
        panel = new Panel();
        container.add(panel);
        panel.add(this.lbz);
        panel.add(this.tfz);
        panel.add(Box.createHorizontalStrut(15));
        panel.add(this.lbt);
        panel.add(this.tft);
        panel = new Panel(flowLayout);
        container.add(panel);
        jLabel = new JLabel(this.str[9]);
        panel.add(jLabel);
        jLabel.setFont(this.bodyFont);
        panel = new Panel(new FlowLayout());
        container.add(panel);
        panel.add(this.brep);
        panel.add(this.bqua);
        panel.add(this.bcac);
        this.group.add(this.brep);
        this.group.add(this.bqua);
        this.group.add(this.bcac);
        this.bcac.setSelected(true);
        container.add(this.table);
        this.table.setVisible(false);
        this.brep.addItemListener(this.radioListener);
        this.bqua.addItemListener(this.radioListener);
        this.bcac.addItemListener(this.radioListener);
        panel = new Panel(flowLayout);
        container.add(panel);
        jLabel = new JLabel(this.str[10]);
        panel.add(jLabel);
        jLabel.setFont(this.bodyFont);
        panel = new Panel();
        container.add(panel);
        panel.add(this.comboFont);
        this.comboFont.setSelectedIndex(this.getIndex(this.fontName, this.fontNames));
        panel.add(this.comboSize);
        this.comboSize.setPrototypeDisplayValue("    ");
        this.comboSize.setPreferredSize(new Dimension(50, 22));
        this.comboSize.setEditable(true);
        this.comboSize.setSelectedIndex(this.getIndex("" + this.fontSize, this.fontSizes));
        panel = new Panel();
        container.add(panel);
        panel.setLayout(new BoxLayout(panel, 0));
        JButton jButton = new JButton(this.str[11]);
        jButton.setFont(this.bodyFont);
        panel.add(jButton);
        jButton.addMouseListener(this.buttonListener);
        panel.add(Box.createHorizontalGlue());
        JButton jButton2 = new JButton(this.str[12]);
        jButton2.setFont(this.bodyFont);
        panel.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrefsPane.this.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        dessin.P = this;
        this.refresh();
    }

    String[] windowDatas() {
        return new String[]{dessin.NF.format(dessin.XG), dessin.NF.format(dessin.XD), dessin.NF.format(dessin.YB), dessin.NF.format(dessin.YH), dessin.NF.format(dessin.UX), dessin.NF.format(dessin.UY), dessin.NF.format(dessin.QX), dessin.NF.format(dessin.QY), dessin.NF.format(dessin.USER_GRID), dessin.NF.format(dessin.ROUND)};
    }

    void affectDatas(String[] stringArray) {
        for (int i = 0; i < this.TF.length; ++i) {
            this.TF[i].setText(stringArray[i]);
        }
    }

    void refresh() {
        this.affectDatas(this.windowDatas());
    }

    String[] gatherDatas() {
        String[] stringArray = new String[this.TF.length];
        for (int i = 0; i < this.TF.length; ++i) {
            stringArray[i] = this.TF[i].getText();
        }
        return stringArray;
    }

    class LineDescriptor {
        short p;
        short r;
        short g;
        short b;
        short w;
        short c;
        boolean dir;
        float u = 0.0f;
        float v = 1.0f;
        float f = (this.v - this.u) / (float)this.p;

        LineDescriptor(short s) {
            this.p = s;
            this.reset();
        }

        void reset(short s) {
            this.p = s;
            this.reset();
        }

        void reset() {
            this.u = 0.0f;
            this.v = 1.0f;
            this.f = (this.v - this.u) / (float)this.p;
            this.r = 0;
            this.g = this.p;
            this.c = 1;
            this.b = 1;
            this.w = (short)2;
            this.dir = false;
        }

        void reset(float f, float f2) {
            this.u = f;
            this.v = f2;
            this.f = (this.v - this.u) / (float)this.p;
            this.r = 0;
            this.g = this.p;
            this.c = 1;
            this.b = 1;
            this.w = (short)2;
            this.dir = false;
        }

        float floatV(int n) {
            return this.u + this.f * (float)n;
        }

        void next() {
            this.c = this.dir ? (short)(this.c + 1) : (short)(this.c - 1);
            if (this.w == 0) {
                this.r = this.c;
            } else if (this.w == 1) {
                this.g = this.c;
            } else {
                this.b = this.c;
            }
            if (this.dir && this.c == this.p || !this.dir && this.c == 0) {
                this.w = (short)(this.w + 1);
                if (this.w == 3) {
                    this.w = 0;
                }
                this.dir = !this.dir;
            }
        }

        Color nextColor() {
            this.next();
            return new Color(this.floatV(this.r), this.floatV(this.g), this.floatV(this.b));
        }
    }

    class TableColor
    extends JPanel {
        int l;
        int c;
        int w;
        int h;
        int i0;
        int j0;
        boolean selected = false;
        Color[][] tab;
        MouseListener colorListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TableColor.this.i0 = mouseEvent.getY() / TableColor.this.h;
                TableColor.this.j0 = mouseEvent.getX() / TableColor.this.w;
                TableColor.this.selected = true;
                Color color = TableColor.this.tab[TableColor.this.i0][TableColor.this.j0];
                if (PrefsPane.this.brep.isSelected()) {
                    dessin.AXIS_COLOR = color;
                }
                if (PrefsPane.this.bqua.isSelected()) {
                    dessin.GRID_COLOR = color;
                }
                TableColor.this.repaint();
                PrefsPane.this.Z.repaint();
            }
        };

        public TableColor(short s, short s2, short s3, short s4) {
            int n;
            float f;
            float f2;
            this.l = s + 1 + s / 2;
            this.c = 6 * s2 + 1;
            this.h = s3;
            this.w = s4;
            this.tab = new Color[this.l][this.c];
            this.setPreferredSize(new Dimension(this.c * this.w, this.l * this.h));
            this.addMouseListener(this.colorListener);
            LineDescriptor lineDescriptor = new LineDescriptor(s2);
            for (f2 = 0.0f; f2 < (float)this.l; f2 += 1.0f) {
                f = 1.0f - f2 / ((float)this.l - 1.0f);
                this.tab[(int)f2][0] = new Color(f, f, f);
            }
            for (n = 1; n < this.c; ++n) {
                this.tab[s][n] = lineDescriptor.nextColor();
            }
            for (f2 = 0.0f; f2 < (float)s; f2 += 1.0f) {
                f = 1.0f - (f2 + 1.0f) / ((float)s + 1.0f);
                lineDescriptor.reset(f, 1.0f);
                for (n = 1; n < this.c; ++n) {
                    Color color = lineDescriptor.nextColor();
                    this.tab[(int)f2][n] = color;
                    Color color2 = color;
                }
            }
            for (f2 = 0.0f; f2 < (float)(s / 2); f2 += 1.0f) {
                f = 1.0f - (f2 + 1.0f) / ((float)s + 1.0f);
                lineDescriptor.reset(0.0f, f);
                for (n = 1; n < this.c; ++n) {
                    this.tab[s + 1 + (int)f2][n] = lineDescriptor.nextColor();
                }
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 0; i < this.l; ++i) {
                for (int j = 0; j < this.c; ++j) {
                    graphics.setColor(this.tab[i][j]);
                    graphics.fillRect(j * this.w, i * this.h, this.w - 1, this.h - 1);
                }
            }
            if (!this.selected) {
                return;
            }
            Color color = this.tab[this.i0][this.j0];
            if (color.getRed() + color.getGreen() + color.getBlue() > 382) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.drawOval(this.j0 * this.w, this.i0 * this.h, this.w - 1, this.h - 1);
        }
    }
}

